/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 * $Log: feltg.c,v $
 * Revision 1.1  1993/09/30  14:30:46  lotos
 * Initial revision
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: feltg.c,v 1.1 1993/09/30 14:30:46 lotos Exp $";
#endif

# include "swbus.h"

PUBLIC char	sfile[BUFSIZ];
PUBLIC char	lfile[BUFSIZ];
PUBLIC char	cfile[BUFSIZ];

PUBLIC int nfname;
PRIVATE char filename[BUFSIZ];
IAT* grnl;
FILE*   yyin;

PUBLIC FILE*	sfp;
PUBLIC FILE*	lfp;
PUBLIC FILE*	cfp;

PUBLIC HT	hidtbl;

int     lexdebug= 0;
int	errorcount= 0;
PRIVATE void    makenames ();
PRIVATE void    help ();
PRIVATE FILE*   efopen();

/* KJT 11/03/98: removed for NS/OS */

#ifndef __NeXT__
/* Kjt 20/01/23: changed type from char * malloc() */
void *   malloc (size_t);
#endif

PRIVATE TIOCOLOURS iocolours [] = {
# include "colours.c"
	OTHERS
	};

CLR_TYPE
eval ()
{
  (void) fprintf (stderr,"Who called this?\n\n");
  exit (1);
}


PRIVATE void
makenames ()
{
  char *p1;

  nfname= -1;
  if (strlen (sfile) == 0)
    (void) strcpy (filename, "feltg");
  else {
    (void) strcpy (filename, sfile);
    p1 = strrchr (sfile, '/');
    if (p1)
      (void) strcpy (filename, ++p1);
    p1= strrchr (filename, '.');
    if (p1) {
      if (strcmp (p1, ".pcp") == 0)
	*p1 = '\0';
    }
    else
      (void) strcat (sfile, ".tp");
    nfname= STHadd (sfile, SymbolTable, hidtbl, FALSE);
  }
  (void) strcpy (cfile, filename);
  (void) strcat (cfile, ".com");
  (void) strcpy (lfile, filename);
  (void) strcat (lfile, ".lis");
}

PRIVATE	FILE*
efopen(file, mode)
     char* file;
     char* mode;
{
  FILE* fp;
  FILE* fopen();

  if ((fp= fopen (file, mode)) == NULL) {
    (void) fprintf (stderr,
		    "cannot open file %s mode %s\n",
		    file, mode);
    exit (1);
  }
  return fp;
} /* end of efopen */

PRIVATE void
help    ()
{
  (void) fprintf (stderr, "usage: feltg [source[.pcp]]\n");
}


PUBLIC int
main (argc, argv)
     int argc;
     char* argv[];
{
  int i, c;
  TNODE* tree;

  while (argc > 1) {
    if (argv[1][0] == '-') {
      i= 0;
      while ((c= argv[1][++i]) != '\0')
	switch (c) {
	case 'd':
	  lexdebug++;
	  break;
	default:
	  help ();
	  exit (1);
	}
    }
    else
      (void) strcpy (sfile, argv[1]);
    argc--;
    argv++;
  }
  cast_init(iocolours);
  stinit(5000);
  SymbolTable= STcreate(100, 0, 1, TRUE);
  hidtbl= STHinit (SymbolTable, 5119);
  grnl= IATcreate (100, 10, 1);

  makenames ();
  if (strlen (sfile) == 0)
    sfp = stdin;
  else {
    sfp = efopen (sfile, "r");
    yyin=sfp;
  }

  tree= bast();

  if (errorcount == 0 && tree != NULL) {
    set_attr(c_name, tree, (CLR_TYPE) filename);
    set_attr(c_ll, tree, (CLR_TYPE) SymbolTable);
    set_attr(c_grnl, tree, (CLR_TYPE) grnl);
    if (ragerrors != 0) {
      (void) fprintf (stderr, "***  feltg: errors detected\n");
      exit (1);
    }
  }

  save_tree(stdout, tree);
  exit (0);
  return 0;
}
