/*************************************************************
*      ltgswbus.h: LOTOS testing tool (software bus)
*************************************************************/
/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 * $Log: ltgswbus.h,v $
 * Revision 1.2  1993/10/18  17:57:04  lotos
 * cleanup interface to interlib
 *
 * Revision 1.1  1993/09/30  14:30:46  lotos
 * Initial revision
 *
 ***********************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern


#include <stdio.h>
#include <assert.h>
#include "cast.hh"
#include "rag.hh"
#include "nodes.h"
#include "omcolours.h"
#include "intercolours.h"
#include "inter.hh"

# define c_actl		102
# define c_factl	103
# define c_gmax		104
# define c_gmin		105
# define c_max		106
# define c_min		107
# define c_tof		108
# define c_print	109
# define c_obj		110
# define c_exp		111
# define c_exl		112

/* test nodes labels */
# define NONE 0
# define MAIN 1
# define LATERAL 2

# define INCONCLUSIVE  1
# define TACCEPT 2
# define TREFUSE  3

/******* public types *********/
/* Test Case Tree */

#define PRT	1
#define NPRT	0
       /**** action  nodes ***/
typedef struct Taction {
	int		sob;
	int		sobj;
        struct Tactcol* actl;
        struct Taction* prev;
        struct Taction* brothers;
        struct Taction* sons;
        char*           actname;
	int		order; /* order in the actlist */
	offert		off; /* offert to go from state lsp to state nsp */
	spe 		lsp; /* origin state of off */
	spe 		nsp; /* final state of off */
	int		type; /* leaf type ACCEPT || REFUSE || INCONCLUSIVE*/
	int		depth; /* nitial value -1*/
        TNODE*          obj;
	int		bt; /* branch type */
        } TNaction;

       /**** test offerts ***/
typedef struct Expr {
	int	type; /* VARIABLE or VALUE	*/
	int	val;  /* ONLY != -1 WHEN VALUE */
	int	sort; /* OPTIONAL != 1 WHEN VALUE */
	} expr;

typedef struct TestOf {
	char*	name;
	expr**	explist;
	int	nexp;
	} testof;

       /**** action colour ***/
typedef struct Prev{
        struct Tactcol* pactl;
        int             ldepth;
        int             pactlpos;
} prevs;

typedef struct Tactcol {
        TNaction**      actions;
        prevs**         prevsobj;
        int             nsons;
        int             maxsons;
        } TNactcol;


/* posible verdicts */
#define v_PASS 0
#define v_FAIL 1
#define v_INCONCLUSIVE 2

/* experiment type */
#define VARIABLE 0
#define VALUE	 1

/******* public variables *********/
SHARED char*	progname;
SHARED int	flagd;
SHARED IAT*	Lgrnl;
SHARED FILE*	ofp;

/******* public functions *********/
/* debugging */

void dspe();
void dg();

/* test cases */
PUBLIC CLR_TYPE	readacts	();
PUBLIC void	writeacts	();
PUBLIC void	writeact	();
PUBLIC void	wrtof		();
PUBLIC void	wrexp		();
PUBLIC void	wrexl		();

PUBLIC void*	my_realloc	();
PUBLIC char*	emalloc		();

PUBLIC TNactcol*mkactl		();
PUBLIC TNactcol*mkractl		();
PUBLIC expr*	mkexp		();
PUBLIC testof*	mktof		();

PUBLIC TNactcol*newactcol	();
PUBLIC TNactcol*newactl		();
PUBLIC testof*	newtestof	();
PUBLIC expr*	newexp		();

PUBLIC int	l2i		();

PUBLIC int	wrttest		();
PUBLIC spe 	spinit		();

