/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: make.c,v $
 * Revision 2.5  1993/02/22  16:14:45  lotos
 * bug fixing
 *
 * Revision 2.4  1993/01/18  18:25:53  lotos
 * distribution issues
 *
 * Revision 2.3  1993/01/12  14:28:28  lotos
 * minor bug fixing
 *
 * Revision 2.2  1992/11/17  17:27:06  lotos
 * var -> rav
 * success -> xto
 * distinguish kdatum / udatum
 *
 * Revision 2.1  1992/10/20  17:49:56  lotos
 * new KT evaluation algorithm
 * new Lbeta interface
 * cleaning, code optimization, space saving, bugs, ...
 *
 * Revision 1.10  1992/09/11  16:54:24  lotos
 * fix tree re-evaluation to take care of priorities
 *
 * Revision 1.9  1992/09/02  17:34:52  lotos
 * added new parameter in mk_exit & mk_ad (sort list code)
 *
 * Revision 1.8  1992/05/07  19:52:41  lotos
 * initialization of structures revisited for completeness
 *
 * Revision 1.7  92/03/05  17:37:06  lotos
 * just a few more bugs went to the hell
 * 
 * Revision 1.6  92/03/04  15:14:24  lotos
 * 
 * a typing error!
 * 
 * Revision 1.5  92/03/04  14:52:47  lotos
 * 100 minor bugettes
 * 
 * Revision 1.4  92/02/29  13:26:06  lotos
 * miscellaneous bug fixing
 *
 * Revision 1.3  92/02/12  18:47:42  lotos
 * ni idea, era una version que andaba por ahi ...
 *
 * Revision 1.2  92/01/15  12:41:01  lotos
 * a bug in frames
 * change success and values
 *
 * Revision 1.1  92/01/14  19:25:13  lotos
 * Initial revision
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: make.c,v 2.5 1993/02/22 16:14:45 lotos Exp $";
#endif

#include "swbus.h"
/* LINTLIBRARY */

   /* --             STACK STUFF          -- */

PUBLIC  int stp_exp = 1;
PUBLIC  int stp_gte = 1;

PUBLIC  stacks_exp  st_exp[MAX_ST];
PUBLIC  stacks_gte  st_gte[MAX_ST];

   /* --              STACK VARS            -- */

  /*------------------------------------------------
    ------------------------------------------------
    --             MAKE ALL LEAVES                --
    ------------------------------------------------
    ----------------------------------------------*/


void
  mkad  (brd, ent, gte, nexps,sort_id, prdct, priority)
board       brd;
entryp      ent;
gate        gte;
int         nexps;
int         sort_id;
predi       prdct;
int         priority;

{
  exp_list  exp;
  offert    off;
  int       i;

  off       = newoff ();
  exp       = newexpa ();

  if (nexps != 0) {
    off->f_eval = FALSE;
    for (i=nexps -1; i >= 0; i--){
      exp[i] = pop_exp();
      off->f_eval =  off->f_eval|| (exp[i]->eval != NO_EVAL);
    }
  }

  brd->btype    = b_ad;
  brd->frm->ent = ent;

  off->adg      = gte;
  off->sort_id  = sort_id;
  off->exp      = exp;
  off->prd      = prdct;
  off->f_prd    = (prdct !=  NO_PRD);
  off->prior    = priority;
  off->act[0]   = brd;

  brd->frm->off     = off;
  insert_lq (brd);
}

void
mkch (brd ,entry1, entry2 )
  board brd;
  entryp  entry1;
  entryp  entry2;
{
  set_type (brd, b_ch);
  if (brd->frm->ch == NULL)
    brd->frm->ch = brd;
  two_new_sons (brd, entry1, entry2);
}

void
mkdis (brd , ent, ent2)
  board brd;
  entryp  ent;
  entryp  ent2;
{
  set_type (brd, b_ds);
  brd->but = brd->frm->but;
  two_new_sons (brd, ent, ent2);
  if ( sson(brd)->frm->dis == NULL)
    sson(brd)->frm->dis= brd;
}

void
  mkdl  (brd, ent,sec)
board   brd;
entryp  ent;
int     sec;
{
  static  offert off;

  off = newoff();
  set_type (brd, b_dl);
  brd->frm->ent  = ent;
  brd->stime    = time (NULL) + sec; /* ojo */
  off->act[0]   = brd;
  brd->frm->off  =off;
  insert_lq (brd);
}

board
mken (brd ,ent, ent2, nvars)
  board   brd;
  entryp  ent;
  entryp  ent2;
  int     nvars;
{
  board     newbrd  = newboard ();
  frame     frm     = brd->frm;
  frame     frm2;

  if (nvars != 0)
    brd->rav = newvar ();
  else
    brd->rav = NULL;
  frm2             = frmcpy (frm);
  brd->btype       = b_en;
  brd->num_fields  = nvars;
  newbrd->fth      = brd;
  brd->sons        = newbrd;
  newbrd->frm      = frm2;
  brd->but         = frm->but;
  frm->ent         = ent2;
  frm2->ent        = ent;
  return (newbrd);
}

void
mkex (brd ,nexps,sort_id, priority)
board brd;
int   nexps;
int   sort_id;
int   priority;
{
  exp_list  exp;
  offert    off = newoff ();
  int i;

  exp = newexpa ();
  for (i= nexps-1; i >=0; i --) {
    exp[i]      = pop_exp ();
    off->f_eval = off->f_eval || (exp[i]->eval != NO_EVAL);
  }
  off->adg     = EXITG;
  off->sort_id = sort_id;
  off->exp     = exp;
  off->act[0]  = brd;
  off->prior   = priority;

  set_type (brd, b_ex);
  brd->offer  = off;
  brd->frm->off  =off;
  insert_lq (brd);
}

void
mkso (val)
  value  val;
{

  static experiment  exp;

  exp         = newexp ();
  exp->class  = '!';
  exp->val    = val;
  exp->rav    = NO_VAR;
  exp->eval   = NO_EVAL;
  push_exp (exp);
}

void
mkuse (val,var)
  value  val;
  variable var;
{

  static experiment  exp;

  exp         = newexp ();
  exp->class  = '!';
  exp->val    = val;
  exp->rav    = var;
  exp->eval   = NO_EVAL;
  push_exp (exp);
}

void
mkmo  (var)
  variable  var;
{
  static experiment  exp;

  exp        = newexp ();
  exp->class = '?';
  exp->rav   = var;
  exp->val   = NULL;
  exp->eval  = NO_EVAL;

  push_exp (exp);
}

void
mkdef (var,def)
  variable  var;
  value def;
{
  static experiment  exp;

  exp        = newexp ();

  exp->class = 'd';
  exp->rav   = var;
  exp->val   = def;
  exp->eval  = NO_EVAL;
  push_exp (exp);
}

void
mkeval  (var, ev)
  variable  var;
  int  ev;
{
  static experiment  exp;

  exp        = newexp ();

  exp->class = 'e';
  exp->rav   = var;
  exp->val   = NULL;
  exp->eval  = ev;

  push_exp (exp);
}

board
mkhd  (brd, ent)
  board brd;
  entryp  ent;
{
  if (get_type(father(brd)) == b_hd && konfig.trace == 0) {
    brd->frm->ent = ent;
    return (brd);
  }
  else {
    brd->gte = newgte ();
    brd->but = brd->frm->but;
    set_type (brd, b_hd);
    one_new_son (brd, ent);
    return (fson(brd));
  }
}

void
mki (brd, ent, p)
  board brd;
  entryp  ent;
  int p;
{
  static  offert off;

  off = newoff();
  set_type (brd,b_ii);
  brd->frm->ent = ent;
  off->prior    = p;
  off->act[0]   = brd;
  brd->frm->off  =off;
  insert_lq (brd);
}

void
mkpe (brd, ent,ent2)
  board brd;
  entryp  ent;
  entryp  ent2;
{
  brd->gte = newgte ();
  set_type (brd, b_pe);
  two_new_sons  (brd, ent, ent2);
}

void
mkpi  (brd, ent, ent2)
  board brd;
  entryp  ent;
  entryp  ent2;
{
  set_type (brd, b_pi);
  two_new_sons  (brd, ent, ent2);
}

void
mkps  (brd, ent, ent2)
  board brd;
  entryp ent;
  entryp ent2;
{
  set_type (brd, b_ps);
  two_new_sons  (brd, ent, ent2);
}

void
mkst (brd)
  board brd;
{
  set_type (brd, b_st);
  freeframe (brd->frm);
  brd->frm   = NULL;
}

void
mkwt (brd, ent, func)
  board    brd;
  entryp   ent;
  predi     func;
{
  static  offert off;

  off = newoff();
  set_type (brd, b_wt);
  brd->frm->ent  = ent;
  brd->prd       = func;
  off->act[0]   = brd;
  brd->frm->off  =off;
  insert_lq (brd);
}

board
mkre (brd,ngates)
  board brd;
  int ngates;
{
  board  nbr;
  board  brd2  =brd;
  rel_g_list  gate1  = newrgte ();
  rel_g_list  g2;
  register  int i;

  if (brd->fth->btype != b_re) {
    for (i= ngates; i > 0; i--) {
      gate1[i]= pop_gte();
    }
    brd->btype      = b_re;

    brd->gte_r      = gate1;
    brd->num_fields = ngates;
    nbr             = newboard ();
    brd->sons       = nbr;
    nbr->fth        = brd2;
    nbr->frm        = brd->frm;
    brd->but        = brd->frm->but;
    brd->frm        = NULL;
  }
  else  {
    g2 = brd->fth->gte_r;
    for (i= ngates; i > 0; i--)
      gate1[i]= g2[pop_gte ()];
    freegte (g2); /* nose */
    brd->fth->gte_r= gate1;
    brd->fth->num_fields=  ngates;
    nbr= brd;
    assert (nbr->btype == b_us);
  }
  return nbr;
}

/*********** stack functions */


PUBLIC void
spec_param (nvals, vals)
  int        nvals;
  value_list vals;
{
  register int i;
	
  assert (nvals < max_val);
  for (i= 0; i < nvals; i++) {
    if (vals[i] == NULL) {
       printf("Null parameter (%d) for spec\n",i);
       exit (1);
     }
    Kt->sons->frm->rav[i]= vals[i];
  }
}

