/***********************************
  (C) Copyright 1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: ADAtopo.c,v $
 * Revision 2.11  1995/01/20  14:43:43  lotos
 * new function -main & -compiler
 *
 * Revision 2.10  1995/01/17  10:01:39  lotos
 * direct code generation for unix and msdos
 *
 * Revision 2.9  1994/12/19  15:12:03  lotos
 * prototypes integrated into topo
 * new pieces convention, and integrated into topo
 * clean objects
 *
 * Revision 2.8  1994/10/03  19:28:29  lotos
 * fix cleaning of ldc.a
 *
 * Revision 2.7  1994/10/03  18:34:48  lotos
 * ada code may be splitted into pieces
 *
 * Revision 2.6  1994/10/03  18:09:20  lotos
 * remove flag files
 *
 * Revision 2.5  1993/11/08  17:19:20  lotos
 * omlbADA has no means to break code into pieces (TPCS)
 *
 * Revision 2.4  1993/06/24  09:20:14  lotos
 * Ada cleaning
 *
 * Revision 2.3  1993/06/23  16:06:35  lotos
 * new option -verbose
 *
 * Revision 2.2  1993/06/15  12:51:12  lotos
 * clean object files
 *
 * Revision 2.1  1993/06/10  14:10:24  lotos
 * extract context common part
 * extract C and Ada generation and cleaning functions
 * lots of bugs fixed
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: ADAtopo.c,v 2.11 1995/01/20 14:43:43 lotos Exp $";
#endif

/* LINTLIBRARY */

#include "context.h"

/****************************************************************
** replace '/' => '\'                                          **
****************************************************************/

char*
pcdir (path)
  char *path;
{
  static char MyPath[128];
  char *p;
  char good, bad;

  good= '\\';
  bad= '/';
  (void) strcpy (MyPath, path);
  while ((p= strchr (MyPath, bad)) != NULL)
    *p= good;
  return MyPath;
}

void
Adagenmake (file)
  FILE* file;
{
  char adalib[BUFSIZ];

  if (FlagVerbose)
    sprintf(adalib,"make -f %s.mk", TOPOF_ADACPL);
  else
    sprintf(adalib,"make -s -f %s.mk", TOPOF_ADACPL);

  fprintf(file,"%s_b.a %s.a:\t%s.lbm\n", TNAME, TNAME, SPEC);
  fprintf(file,"\t%s -D %s.a -o %s %s %s\n",
        OMLBADA, DNAME, TNAME, TOPOF_OMLBADA, SPEC);
  fprintf(file,"\n");

  fprintf(file,"%s_b.a %s.a:\t%s.idl\n", DNAME, DNAME, SPEC);
  fprintf(file,"\td2ada -i -c %s < %s.idl > %s\n", TOPOF_D2ADA, SPEC, TMP);
#ifdef MSDOS
  fprintf(file,"\ttype %s > %s.a\n", TMP, DNAME);
#else
  fprintf(file,"\tmv %s %s.a\n", TMP, DNAME);
#endif
  fprintf(file,"\t%s -i -c %s -p%s < %s.idl\n",
        D2ADA_B, TOPOF_D2ADA_B, DNAME, SPEC);
  fprintf(file,"\n");

  fprintf(file,"topomain.a:\n");
  fprintf(file,"\tagtm > topomain.a\n");
  fprintf(file,"\n");

  fprintf(file,"%s.mk:\n", TOPOF_ADACPL);
#ifdef MSDOS
  fprintf(file,"\ttype %s\\ada\\$@ > $@\n", pcdir (TOPOLIB));
#else
  fprintf(file,"\tcp %s%cada%c$@ .\n", TOPOLIB, DIRSEP, DIRSEP);
#endif
  fprintf(file,"\n");

  fprintf(file,"%s.init:\t%s.mk\n", TOPOF_ADACPL, TOPOF_ADACPL);
  fprintf(file,"\t%s init\n", adalib);
  fprintf(file,"\t%s import LIB=%s%ckaos%c%s\n",
	  adalib, TOPOLIB, DIRSEP, DIRSEP, TOPOF_ADARTS);
  fprintf(file,"\t%s import LIB=%s%clabra%c%s\n",
	  adalib, TOPOLIB, DIRSEP, DIRSEP, TOPOF_ADARTS);
#ifdef MSDOS
  fprintf(file,"\ttype %s > $@\n", DEVNULL);
#else
  fprintf(file,"\ttouch $@\n");
#endif
  fprintf(file,"\n");

  fprintf(file,"%s.done:\t%s.a %s_b.a %s.a %s_b.a topomain.a %s.mk\n",
	  TOPOF_ADACPL, DNAME, DNAME, TNAME, TNAME, TOPOF_ADACPL);
  fprintf(file,"\t%s compile SRC=%s.a\n", adalib, DNAME);
  fprintf(file,"\t%s compile SRC=%s_b.a\n", adalib, DNAME);
  fprintf(file,"\t%s compile SRC=%s.a\n", adalib, TNAME);
  fprintf(file,"\t%s compile SRC=%s_b.a\n", adalib, TNAME);
  fprintf(file,"\t%s compile SRC=topomain.a\n", adalib);
  fprintf(file,"\t%s link MAIN=main TRGT=%s\n", adalib, SPEC);
#ifdef MSDOS
  fprintf(file,"\ttype %s > $@\n", DEVNULL);
#else
  fprintf(file,"\ttouch $@\n");
#endif
  fprintf(file,"\n");

  fprintf(file,"%s:\t%s.a %s_b.a %s.a %s_b.a topomain.a %s.init %s.done\n",
	  SPEC, DNAME, DNAME, TNAME, TNAME, TOPOF_ADACPL, TOPOF_ADACPL);
  fprintf(file,"\n");
}

int
AdaBuildBehaviour ()
{
  sprintf (command, "make -f %s %s_b.a %s", MAKE, TNAME, REDIR);
  return my_system (command);
}

void
AdaCleanBehaviour ()
{
  if (FlagVerbose)
    (void) fprintf (stderr, "remove %s_b.a %s.a\n", TNAME, TNAME);
  (void) sprintf (filename, "%s.a", TNAME);
  (void) unlink (filename);

  (void) sprintf (filename, "%s_b.a", TNAME);
  (void) unlink (filename);

  if (atoi (TPCS) > 1) {
    if (FlagVerbose)
      (void) fprintf (stderr, "remove %s*.a\n", TNAME);
    unlink_pcs(TNAME, "a", atoi (TPCS));
  }
}

int
AdaBuildData ()
{
  sprintf (command, "make -f %s %s_b.a %s", MAKE, DNAME, REDIR);
  return my_system (command);
}

int
AdaBuildMain ()
{
  sprintf (command, "make -f %s topomain.a %s", MAKE, REDIR);
  return my_system (command);
}

int
AdaBuildCompiler ()
{
  sprintf (command, "make -f %s %s.mk %s", MAKE, TOPOF_ADACPL, REDIR);
  return my_system (command);
}

void
AdaCleanData ()
{
  if (FlagVerbose)
    (void) fprintf (stderr, "remove %s_b.a %s.a\n", DNAME, DNAME);
  (void) sprintf (filename, "%s.a", DNAME);
  (void) unlink (filename);

  (void) sprintf (filename, "%s_b.a", DNAME);
  (void) unlink (filename);

  if (atoi (DPCS) > 1) {
    if (FlagVerbose)
      (void) fprintf (stderr, "remove %s*.a\n", DNAME);
    unlink_pcs(DNAME, "a", atoi (DPCS));
  }
}

void
AdaCleanObject ()
{
  char* s;
  char adalib[BUFSIZ];

  if ((s= getenv ("TOPOF_ADACPL")) != NULL) {
    if (FlagVerbose)
      sprintf(adalib,"make -f %s.mk", s);
    else
      sprintf(adalib,"make -s -f %s.mk", s);
    (void) sprintf (filename, "%s.mk", s);
    if (read_ok (filename)) {
      (void) sprintf (command, "%s clean", adalib);
      (void) my_system (command);

      (void) sprintf (filename, "%s.done", s);
      if (FlagVerbose)
	(void) fprintf (stderr, "remove %s\n", filename);
      (void) unlink (filename);

      (void) sprintf (filename, "%s.init", s);
      if (FlagVerbose)
	(void) fprintf (stderr, "remove %s\n", filename);
      (void) unlink (filename);
    }
  }
}

