/***********************************
  (C) Copyright 1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: Ctopo.c,v $
 * Revision 2.8  1995/01/20  14:43:35  lotos
 * new function -main & -compiler
 *
 * Revision 2.7  1995/01/17  10:01:26  lotos
 * direct code generation for unix and msdos
 *
 * Revision 2.6  1994/12/19  15:11:44  lotos
 * prototypes integrated into topo
 * new pieces convention, and integrated into topo
 * clean objects
 *
 * Revision 2.5  1994/11/21  16:32:43  lotos
 * port to msdos
 *
 * Revision 2.4  1994/10/03  18:09:11  lotos
 * remove flag files
 *
 * Revision 2.3  1993/06/23  16:06:35  lotos
 * new option -verbose
 *
 * Revision 2.2  1993/06/15  12:51:12  lotos
 * clean object files
 *
 * Revision 2.1  1993/06/10  14:10:24  lotos
 * extract context common part
 * extract C and Ada generation and cleaning functions
 * lots of bugs fixed
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: Ctopo.c,v 2.8 1995/01/20 14:43:35 lotos Exp $";
#endif

/* LINTLIBRARY */

#include "context.h"

void
Cgenmake (file)
  FILE* file;
{
  fprintf(file,"%s.c %s.hh:\t%s.lbm\n", TNAME, TNAME, SPEC);
  fprintf(file,"\t%s -D %s.hh -o %s %s %s\n",
	  OMLBC, DNAME, TNAME, TOPOF_OMLBC, SPEC);
  fprintf(file,"\n");

  fprintf(file,"%s.c %s.hh:\t%s.idl\n", DNAME, DNAME, SPEC);
  fprintf(file,"\td2h -i -c %s < %s.idl > %s\n", TOPOF_D2H, SPEC, TMP);
#ifdef MSDOS
  fprintf(file,"\ttype %s > %s.hh\n", TMP, DNAME);
#else
  fprintf(file,"\tmv %s %s.hh\n", TMP, DNAME);
#endif
  fprintf(file,"\t%s -i -c %s -p%s %s.hh < %s.idl\n",
	  D2C, TOPOF_D2C, DNAME, DNAME, SPEC);
  fprintf(file,"\n");

  fprintf(file,"topomain.c:\n");
  fprintf(file,"\tgtm > topomain.c\n");
  fprintf(file,"\n");

  fprintf(file,"%s.o:\t%s.hh %s.c\n", DNAME, DNAME, DNAME);
  fprintf(file,"\t$(CC) $(CFLAGS) -I%s -c %s.c\n", TOPOINC, DNAME);
  fprintf(file,"\n");

  fprintf(file,"%s.o:\t%s.hh %s.hh %s.c\n", TNAME, DNAME, TNAME, TNAME);
  fprintf(file,"\t$(CC) $(CFLAGS) -I%s -c %s.c\n", TOPOINC, TNAME);
  fprintf(file,"\n");

  fprintf(file,"topomain.o:\ttopomain.c\n");
  fprintf(file,"\t$(CC) $(CFLAGS) -I%s -c topomain.c\n", TOPOINC);
  fprintf(file,"\n");

  fprintf(file,"%s:\t%s.o %s.o topomain.o\n", SPEC, TNAME, DNAME);
  fprintf(file,"\t$(CC) $(CFLAGS) -I%s -o $@ %s.o %s.o topomain.o",
	  TOPOINC, TNAME, DNAME);
  fprintf(file," -L%s -lotos -lkaos\n", TOPOLIB);
  fprintf(file,"\n");
}

int
CBuildBehaviour ()
{
  sprintf (command, "make -f %s %s.c %s", MAKE, TNAME, REDIR);
  return my_system (command);
}

void
CCleanBehaviour ()
{
  if (FlagVerbose)
    (void) fprintf (stderr, "remove %s.c %s.hh\n", TNAME, TNAME);
  (void) sprintf (filename, "%s.hh", TNAME);
  (void) unlink (filename);

  (void) sprintf (filename, "%s.c", TNAME);
  (void) unlink (filename);

  if (atoi (TPCS) > 1) {
    if (FlagVerbose)
      (void) fprintf (stderr, "remove %s*.c\n", TNAME);
    unlink_pcs(TNAME, "c", atoi (TPCS));
  }
}

int
CBuildData ()
{
  sprintf (command, "make -f %s %s.c %s", MAKE, DNAME, REDIR);
  return my_system (command);
}

int
CBuildMain ()
{
  sprintf (command, "make -f %s topomain.c %s", MAKE, REDIR);
  return my_system (command);
}

int
CBuildCompiler ()
{
  return 1;
}

void
CCleanData ()
{
  if (FlagVerbose)
    (void) fprintf (stderr, "remove %s.c %s.hh\n", DNAME, DNAME);
  (void) sprintf (filename, "%s.hh", DNAME);
  (void) unlink (filename);

  (void) sprintf (filename, "%s.c", DNAME);
  (void) unlink (filename);

  if (atoi (DPCS) > 1) {
    if (FlagVerbose)
      (void) fprintf (stderr, "remove %s*.c\n", DNAME);
    unlink_pcs(DNAME, "c", atoi (DPCS));
  }
}

void
CCleanObject ()
{
  (void) sprintf (filename, "%s.%s", TNAME, OBJEXT);
  if (FlagVerbose)
    (void) fprintf (stderr, "remove %s\n", filename);
  (void) unlink (filename);
  if (atoi (TPCS) > 1) {
    if (FlagVerbose)
      (void) fprintf (stderr, "remove %s*.%s\n", TNAME, OBJEXT);
    unlink_pcs(TNAME, OBJEXT, atoi (TPCS));
  }

  (void) sprintf (filename, "%s.%s", DNAME, OBJEXT);
  if (FlagVerbose)
    (void) fprintf (stderr, "remove %s\n", filename);
  (void) unlink (filename);
  if (atoi (DPCS) > 1) {
    if (FlagVerbose)
      (void) fprintf (stderr, "remove %s*.%s\n", DNAME, OBJEXT);
    unlink_pcs(DNAME, OBJEXT, atoi (DPCS));
  }

  (void) sprintf (filename, "topomain.%s", OBJEXT);
  if (FlagVerbose)
    (void) fprintf (stderr, "remove %s\n", filename);
  (void) unlink (filename);
}

