# include "rag.hh"
# include "nodes.h"
# include "grc.h"

IAT* grnl= NULL;

# include "swbus.h"
# define set_first_son(pfather,pson) { pson->brothers = pfather->sons; \
pfather->sons = pson; \
pson->father = pfather; }

PRIVATE void
PROCESINI (r)
    TNODE* r;
{
  TNODE* h[33];
  /* KJT 20/01/23: added "int" type */
  register int i;
  int nr;
  int* grl;

  while (r != NULL) {
    h[0]= r;
    heval (r, h);
    grl= grnl->data[(int)(r->value0)];
    for (i= 0; grl[i] != 0; i++) {
     nr= grl[i];
     switch (nr) {
      case _specification_1:
	 if (h[0] != NULL)
	  adclr (-c_lbm, h[0], 1);
	 if (h[0] != NULL)
	  adclr (-c_annot_list, h[0], 2);
	 if (h[0] != NULL)
	  adclr (-c_last_annot_list, h[0], 3);
	 if (h[0] != NULL)
	  adclr (-c_BUT_def_list, h[0], 4);
	 if (h[0] != NULL)
	  adclr (-c_BUT_def, h[0], 5);
	 break;
      case _definition_block_1:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 6);
	 if (h[0] != NULL)
	  adclr (-c_BUT_list, h[0], 7);
	 break;
      case _local_definitions_1:
	 if (h[0] != NULL)
	  adclr (-c_BUT_list, h[0], 8);
	 break;
      case _formal_equations_1:
	 if (h[1] != NULL)
	  adclr (-c_is_experiment, h[1], 9);
	 break;
      case _equations_1:
	 if (h[1] != NULL)
	  adclr (-c_is_experiment, h[1], 10);
	 break;
      case _equation_list_1:
	 if (h[2] != NULL)
	  adclr (-c_is_experiment, h[2], 11);
	 break;
      case _simple_equation_1:
	 adclr (-c_value_exp, h[0], 12);
	 adclr (-c_value_exp2, h[0], 13);
	 break;
      case _process_definition_1:
	 adclr (-c_BUT_list, h[0], 14);
	 adclr (-c_BUT_def, h[0], 15);
	 break;
      case _formal_parameter_list_1:
	 if (h[0] != NULL)
	  adclr (-c_gate_decl, h[0], 16);
	 if (h[0] != NULL)
	  adclr (-c_var_list, h[0], 17);
	 break;
      case _gate_parameter_list_1:
	 if (h[0] != NULL)
	  adclr (-c_gate_decl, h[0], 18);
	 break;
      case _value_parameter_list_1:
	 adclr (-c_var_list, h[0], 19);
	 adclr (-c_is_experiment, h[1], 20);
	 break;
      case _local_definition_expression_1:
	 adclr (-c_state, h[0], 21);
	 adclr (-c_annot_list, h[0], 22);
	 break;
      case _identifier_equations_1:
	 if (h[0] != NULL)
	  adclr (-c_ident_equation_list, h[0], 23);
	 break;
      case _identifier_equation_1:
	 adclr (-c_ident_equation, h[0], 24);
	 adclr (-c_is_experiment, h[1], 25);
	 break;
      case _sum_expression_1:
	 adclr (-c_state, h[0], 26);
	 adclr (-c_annot_list, h[0], 27);
	 adclr (-c_is_experiment, h[1], 28);
	 break;
      case _par_expression_1:
	 adclr (-c_state, h[0], 29);
	 adclr (-c_annot_list, h[0], 30);
	 break;
      case _parallel_operator_1:
	 adclr (-c_par_type, h[0], 31);
	 break;
      case _parallel_operator_2:
	 adclr (-c_par_type, h[0], 32);
	 break;
      case _parallel_operator_3:
	 if (h[0] != NULL)
	  adclr (-c_par_type, h[0], 33);
	 if (h[0] != NULL)
	  adclr (-c_gate_list, h[0], 34);
	 break;
      case _hiding_expression_1:
	 adclr (-c_state, h[0], 35);
	 adclr (-c_annot_list, h[0], 36);
	 break;
      case _enable_expression_1:
	 adclr (-c_state, h[0], 37);
	 adclr (-c_annot_list, h[0], 38);
	 break;
      case _enable_operator_1:
	 if (h[0] != NULL)
	  adclr (-c_var_list, h[0], 39);
	 if (h[1] != NULL)
	  adclr (-c_is_experiment, h[1], 40);
	 break;
      case _disable_expression_1:
	 adclr (-c_state, h[0], 41);
	 adclr (-c_annot_list, h[0], 42);
	 break;
      case _parallel_expression_1:
	 adclr (-c_state, h[0], 43);
	 adclr (-c_annot_list, h[0], 44);
	 break;
      case _choice_expression_1:
	 adclr (-c_state, h[0], 45);
	 adclr (-c_annot_list, h[0], 46);
	 break;
      case _guarded_expression_1:
	 adclr (-c_state, h[0], 47);
	 adclr (-c_annot_list, h[0], 48);
	 break;
      case _action_prefix_expression_1:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 49);
	 if (h[0] != NULL)
	  adclr (-c_annot_list, h[0], 50);
	 break;
      case _action_denotation_1:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 51);
	 if (h[0] != NULL)
	  adclr (-c_annot, h[0], 52);
	 if (h[0] != NULL)
	  adclr (-c_experiment_list, h[0], 53);
	 if (h[0] != NULL)
	  adclr (-c_predicate, h[0], 54);
	 break;
      case _action_denotation_2:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 55);
	 if (h[0] != NULL)
	  adclr (-c_experiment_list, h[0], 56);
	 if (h[0] != NULL)
	  adclr (-c_predicate, h[0], 57);
	 if (h[0] != NULL)
	  adclr (-c_annot, h[0], 58);
	 break;
      case _action_denotation_3:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 59);
	 if (h[0] != NULL)
	  adclr (-c_annot, h[0], 60);
	 if (h[0] != NULL)
	  adclr (-c_experiment_list, h[0], 61);
	 break;
      case _experiment_offer_list_1:
	 if (h[0] != NULL)
	  adclr (-c_experiment_list, h[0], 62);
	 break;
      case _experiment_offer_1:
	 adclr (-c_var_id_node, h[0], 63);
	 adclr (-c_is_experiment, h[1], 64);
	 break;
      case _experiment_offer_2:
	 adclr (-c_value_exp, h[0], 65);
	 break;
      case _selection_predicate_1:
	 if (h[0] != NULL)
	  adclr (-c_predicate, h[0], 66);
	 break;
      case _atomic_expression_1:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 67);
	 if (h[0] != NULL)
	  adclr (-c_annot_list, h[0], 68);
	 break;
      case _atomic_expression_2:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 69);
	 if (h[0] != NULL)
	  adclr (-c_exit_offer_list, h[0], 70);
	 if (h[0] != NULL)
	  adclr (-c_annot_list, h[0], 71);
	 break;
      case _atomic_expression_3:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 72);
	 if (h[2] != NULL)
	  adclr (-c_annot, h[2], 73);
	 break;
      case _process_instantiation_1:
	 if (h[0] != NULL)
	  adclr (-c_state, h[0], 74);
	 if (h[0] != NULL)
	  adclr (-c_annot_list, h[0], 75);
	 if (h[0] != NULL)
	  adclr (-c_val_exp_list, h[0], 76);
	 break;
      case _actual_gate_list_1:
	 if (h[0] != NULL)
	  adclr (-c_gate_list, h[0], 77);
	 break;
      case _identifier_declarations_1:
	 if (h[0] != NULL)
	  adclr (-c_var_domain_list, h[0], 78);
	 if (h[0] != NULL)
	  adclr (-c_gte_var_list, h[0], 79);
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_is_experiment, h[3], 80);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 break;
      case _identifier_declaration_1:
	 adclr (-c_var_id_node, h[0], 81);
	 adclr (-c_gte_var_list, h[0], 82);
	 adclr (-c_is_experiment, h[1], 83);
	 break;
      case _gate_declarations_1:
	 if (h[0] != NULL)
	  adclr (-c_gate_domain_list, h[0], 84);
	 break;
      case _gate_list_1:
	 if (h[0] != NULL)
	  adclr (-c_gate_list, h[0], 85);
	 break;
      case _gate_declaration_list_1:
	 if (h[0] != NULL)
	  adclr (-c_gate_decl, h[0], 86);
	 break;
      case _gate_declaration_1:
	 if (h[0] != NULL)
	  adclr (-c_gate_domain, h[0], 87);
	 if (h[1] != NULL)
	  adclr (-c_is_experiment, h[1], 88);
	 break;
      case _identifier_declaration_list_1:
	 h[3]= h[1];
	 h[4]= gt_rb (h[3]);
	 while (h[3] != NULL) {
	  adclr (-c_is_experiment, h[3], 89);
	  h[3]= h[4];
	  h[4]= gt_rb (h[4]);
	 }
	 if (h[0] != NULL)
	  adclr (-c_var_id_node, h[0], 90);
	 if (h[0] != NULL)
	  adclr (-c_gte_var_list, h[0], 91);
	 break;
      case _identifier_1:
	 if (h[0] != NULL)
	  adclr (-c_var_id_node, h[0], 92);
	 if (h[0] != NULL)
	  adclr (-c_annot_list, h[0], 93);
	 break;
      default:
	 assert ((1 <= nr) && (nr <= LAST_RULE));
      }
    } /* end of while (ngr != NULL) */
    r= succ (r, PREORDER);
  } /* end of while (r != NULL) */
} /* end of PROCESINI */

PUBLIC CLR_TYPE
eval (nar, r)
    int nar;
    TNODE* r;
{
  TNODE* h[33];

  if (r == NULL) return (CLR_TYPE)NULL;
  switch (nar) {
  case 1:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     int   class = 2;
     initgl;
     putgrn (_lbm_1);                         /* grnl for this node */
     aux = do_node (tlbm, class);  /* class may be modified by sons */
	/* the sons will be added in the opposite order they appear */
	/* in the rule, to make easier the connection among them    */
     if ((son = (TNODE*)fdclr (c_last_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
				       /* the 3rd bit is set to one */
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);
     }
	/* The class for the BUT_definition_list son is already set */
     son = (TNODE*)fdclr (c_BUT_def_list,h[0], nar);
     set_first_son (aux, son);
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
				       /* the 1st bit is set to one */
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 1);
     }
      return (CLR_TYPE) aux;
  }
  case 2:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     if (h[3] != NULL) {
       aux = cp_tree ((TNODE*)h[3], TRUE);
       aux->type = tannotation_list;
       initgl;
       putgrn (_annotation_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);     /* set grnl */
       set_grn_type (aux->sons, tannotation, _annotation_1);
     }
      return (CLR_TYPE) aux;
  }
  case 3:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     if (h[6] != NULL) {
       aux = cp_tree ((TNODE*)h[6], TRUE);
       aux->type = tannotation_list;
       initgl;
       putgrn (_annotation_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);     /* set grnl */
       set_grn_type (aux->sons, tannotation, _annotation_1);
     }
      return (CLR_TYPE) aux;
  }
  case 4:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_BUT_definition_list_1);           /* grnl for this node */
     aux = do_node (tBUT_definition_list, 1);
     if ((son = (TNODE*)fdclr (c_BUT_list,h[5], nar)) != NULL)
       if (!lnsons (aux, son))
	 fatal_error ("cannot link sons", __FILE__, __LINE__);
     son= (TNODE*)fdclr (c_BUT_def,h[0], nar);
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 5:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_BUT_definition_1);               /* grnl for this node */
     aux = do_node (tBUT_definition, 1);
     set_attr (c_BUT_number, aux, fdclr (c_iddec,h[1], nar));
     if (h[2] != NULL) {
       if (fdclr (c_gate_decl,h[2], nar) != NULL)
	 set_attr (c_gate_decl, aux, fdclr (c_gate_decl,h[2], nar));
       if (fdclr (c_var_list,h[2], nar) != NULL)
	 set_attr (c_var_list, aux, fdclr (c_var_list,h[2], nar));
     }
     son = (TNODE*)fdclr (c_state,h[5], nar);
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 6:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_state,h[1], nar);
  case 7:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) (h[2] == NULL)
	     ? NULL : fdclr (c_BUT_list,h[2], nar);
  case 8:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
     TNODE *aux = NULL, *son = NULL;
     for (son = gt_fs((TNODE*)h[0]);
	  son != NULL;
	  son = gt_rb (son))
       if (find_attr (c_BUT_list, son) != NULL) {
	 aux = chain_brothers (aux, (TNODE*)fdclr (c_BUT_list, son, nar));
       }
      return (CLR_TYPE) aux;
  }
  case 9:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 10:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 11:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 12:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     aux = cp_tree ((TNODE*)h[1], TRUE);
				/* sets tvalue_exp and grn in all sons */
     set_grn_type (aux, tvalue_exp, _value_exp_1);
      return (CLR_TYPE) aux;
  }
  case 13:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     aux = cp_tree ((TNODE*)h[2], TRUE);
				/* sets tvalue_exp and grn in all sons */
     set_grn_type (aux, tvalue_exp, _value_exp_1);
      return (CLR_TYPE) aux;
  }
  case 14:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     aux = (TNODE*)fdclr (c_BUT_def,h[0], nar);   /* the first brother */
     son = (TNODE*)fdclr (c_BUT_list,h[3], nar);   /* the other brothers */
      return (CLR_TYPE) chain_brothers (aux, son);            /* concat the brothers */
  }
  case 15:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_BUT_definition_1);               /* grnl for this node */
     aux = do_node (tBUT_definition, 1);
     set_attr (c_BUT_number, aux, fdclr (c_iddec,h[1], nar));
     if (fdclr (c_gate_decl,h[2], nar) != NULL)
       set_attr (c_gate_decl, aux, fdclr (c_gate_decl,h[2], nar));
     if (fdclr (c_var_list,h[2], nar) != NULL)
       set_attr (c_var_list, aux, fdclr (c_var_list,h[2], nar));
     son = (TNODE*)fdclr (c_state,h[3], nar);
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 16:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) (h[1] == NULL)
	     ? NULL : fdclr (c_gate_decl,h[1], nar);
  case 17:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) (h[2] == NULL)
	     ? NULL : fdclr (c_var_list,h[2], nar);
  case 18:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_gate_decl,h[1], nar);
  case 19:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_gte_var_list,h[1], nar);
  case 20:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 21:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_let_exp_1);                      /* grnl for this node */
     putgrn (state_1);                  /* it depends on LBM.spe */
     aux = do_node (tlet_exp, 3);              /* At least, two sons */
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);      /* class */
     }
     son = (TNODE*)fdclr (c_state,h[2], nar);
     set_first_son (aux, son);          /* insert the second brother */
     son = (TNODE*)fdclr (c_ident_equation_list,h[1], nar);
     set_first_son (aux, son);           /* insert the first brother */
      return (CLR_TYPE) aux;
  }
  case 22:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 23:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_ident_equation_list_1);          /* grnl for this node */
     aux = do_node (tident_equation_list, 1);
     for (son = gt_fs ((TNODE*)h[0]);
	  son != NULL;
	  son = gt_rb (son)) {
       if (!lnsons (aux, (TNODE*)fdclr (c_ident_equation, son, nar)))
	 fatal_error ("cannot link sons", __FILE__, __LINE__);
     }
      return (CLR_TYPE) aux;
  }
  case 24:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_ident_equation_1);                 /* grnl for this node */
     aux = do_node (tident_equation, 1);
     set_attr (c_var_list, aux, fdclr (c_gte_var_list,h[1], nar));
     son = cp_tree ((TNODE*)h[2], TRUE);
				/* sets tvalue_exp and grn in all sons */
     set_grn_type (son, tvalue_exp, _value_exp_1);
     set_first_son (aux, son);                 /* Insert the first son */
      return (CLR_TYPE) aux;
  }
  case 25:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 26:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
		 /* sum_domain_expression can be a _gate_declaration */
	       /* (gates) or a _identifier_declarations (variables). */
						 /* Cheking if gates */
     if (find_attr (c_gate_domain_list, h[1]) != NULL) {
						/* At least, one son */
       initgl;
       putgrn (_gate_choice_exp_1);            /* grnl for this node */
       putgrn (state_3);                /* it depends on LBM.spe */
       aux = do_node (tgate_choice_exp, 3);
       if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
	 set_first_son (aux, son);
	 aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);    /* class */
       }
       son = (TNODE*)fdclr (c_state,h[2], nar);
       set_first_son (aux, son);
       son = (TNODE*)fdclr (c_gate_domain_list,h[1], nar);
       set_first_son (aux, son);
     }
     else {              /* no gates? then, they should be variables */
						/* At least, one son */
       initgl;
       putgrn (_var_choice_exp_1);             /* grnl for this node */
       putgrn (state_2);                /* it depends on LBM.spe */
       aux = do_node (tvar_choice_exp, 3);
       if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
	 set_first_son (aux, son);
	 aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);    /* class */
       }
       son = (TNODE*)fdclr (c_state,h[2], nar);
       set_first_son (aux, son);
       son = (TNODE*)fdclr (c_var_domain_list,h[1], nar);
       set_first_son (aux, son);
     }
      return (CLR_TYPE) aux;
  }
  case 27:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 28:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 29:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     switch ((int)fdclr (c_par_type,h[2], nar)) {
       case EXPLI:                              /* At least, one son */
	 initgl;
	 putgrn (_par_exp_expli_1);            /* grnl for this node */
	 putgrn (state_6);              /* it depends on LBM.spe */
	 aux = do_node (tpar_exp_expli, 3);
	 set_attr (c_gate_list, aux, fdclr (c_gate_list,h[2], nar));
	 break;
       case INTER:                              /* At least, one son */
	 initgl;
	 putgrn (_par_exp_inter_1);            /* grnl for this node */
	 putgrn (state_5);              /* it depends on LBM.spe */
	 aux = do_node (tpar_exp_inter, 3);
	 break;
       case FULL_SYNCH:                         /* At least, one son */
	 initgl;
	 putgrn (_par_exp_full_synch_1);       /* grnl for this node */
	 putgrn (state_4);              /* it depends on LBM.spe */
	 aux = do_node (tpar_exp_full_synch, 3);
	 break;
     }
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);      /* class */
     }
     son = (TNODE*)fdclr (c_state,h[3], nar);
     set_first_son (aux, son);
     son = (TNODE*)fdclr (c_gate_domain_list,h[1], nar);
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 30:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 31:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) FULL_SYNCH;
  case 32:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) INTER;
  case 33:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) EXPLI;
  case 34:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) ((h[1] != NULL) ? fdclr (c_gate_list,h[1], nar) : NULL);
  case 35:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_hiding_exp_1);                   /* grnl for this node */
     putgrn (state_7);                  /* it depends on LBM.spe */
     aux = do_node (thiding_exp, 1);            /* At least, one son */
     set_attr (c_gate_decl, aux, fdclr (c_gate_decl,h[1], nar));
		 /* some annotations may come from father, due to    */
		 /* atomic_expression := [ executable_comment_list ] */
		 /*                      ( behaviour_expression )    */
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 2); /* class */
     }
     son = (TNODE*)fdclr (c_state,h[2], nar);
     set_first_son (aux, son);           /* insert the first brother */
      return (CLR_TYPE) aux;
  }
  case 36:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 37:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_enable_exp_1);                   /* grnl for this node */
     putgrn (state_8);                  /* it depends on LBM.spe */
     aux = do_node (tenable_exp, 3);              /* 2 sons at least */
     if (fdclr (c_var_list,h[2], nar) != NULL)
       set_attr (c_var_list, aux, fdclr (c_var_list,h[2], nar));
		 /* some annotations may come from father, due to    */
		 /* atomic_expression := [ executable_comment_list ] */
		 /*                      ( behaviour_expression )    */
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);        /* class */
     }
     son = (TNODE*)fdclr (c_state,h[3], nar);
     set_first_son (aux, son);
     son = (TNODE*)fdclr (c_state,h[1], nar);
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 38:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 39:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE)  (h[1] == NULL)
	     ? NULL
	     : fdclr (c_gte_var_list,h[1], nar);
  case 40:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 41:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_disable_exp_1);                    /* grnl for this node */
     putgrn (state_9);                    /* it depends on LBM.spe */
     aux = do_node (tdisable_exp, 3);               /* 2 sons at least */
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);        /* class */
     }
     son = (TNODE*)fdclr (c_state,h[2], nar);
     set_first_son (aux, son);
     son = (TNODE*)fdclr (c_state,h[1], nar);
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 42:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 43:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     switch ((int)fdclr (c_par_type,h[2], nar)) {
       case EXPLI:
	 initgl;
	 putgrn (_parallel_explicit_1);            /* grnl for this node */
	 putgrn (state_12);                 /* it depends on LBM.spe */
	 aux = do_node (tparallel_explicit, 3);
	 set_attr (c_gate_list, aux, fdclr (c_gate_list,h[2], nar));
	 break;
       case INTER:
	 initgl;
	 putgrn (_parallel_interleaving_1);        /* grnl for this node */
	 putgrn (state_11);                 /* it depends on LBM.spe */
	 aux = do_node (tparallel_interleaving, 3);
	 break;
       case FULL_SYNCH:                               /* 2 sons at least */
	 initgl;
	 putgrn (_parallel_full_synch_1);          /* grnl for this node */
	 putgrn (state_10);                 /* it depends on LBM.spe */
	 aux = do_node (tparallel_full_synch, 3);
	 break;
     }
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);        /* class */
     }
     son = (TNODE*)fdclr (c_state,h[3], nar);
     set_first_son (aux, son);
     son = (TNODE*)fdclr (c_state,h[1], nar);
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 44:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 45:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_choice_exp_1);                     /* grnl for this node */
     putgrn (state_13);                   /* it depends on LBM.spe */
     aux = do_node (tchoice_exp, 3);                /* 2 sons at least */
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 4);        /* class */
     }
     son = (TNODE*)fdclr (c_state,h[2], nar);
     set_first_son (aux, son);
     son = (TNODE*)fdclr (c_state,h[1], nar);
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 46:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 47:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_guard_exp_1);                      /* grnl for this node */
     putgrn (state_14);                   /* it depends on LBM.spe */
     aux = do_node (tguard_exp, 7);                 /* 3 sons at least */
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);                        /* set 4th son */
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 8);        /* class */
     }
     son = (TNODE*)fdclr (c_state,h[2], nar);                /* set 3rd son */
     set_first_son (aux, son);
     son = (TNODE*)fdclr (c_value_exp2,h[1], nar);      /* set 2nd son */
     set_first_son (aux, son);
     son = (TNODE*)fdclr (c_value_exp,h[1], nar);       /* set 1st son */
     set_first_son (aux, son);
      return (CLR_TYPE) aux;
  }
  case 48:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *initial = NULL;
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       if ((initial = (TNODE*)fdclr (c_annot,h[0], nar)) != NULL)
	  return (CLR_TYPE) mk_annot_list (initial);
      return (CLR_TYPE) NULL;
  }
  case 49:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     aux = (TNODE*)fdclr (c_state,h[2], nar);
     switch (aux->type) {
     case tinternal_action :
       if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
	 set_first_son (aux, son);
	 aux->value1 = (CLR_TYPE)((int)aux->value1 + 2);          /* class */
       }
       son = (TNODE*)fdclr (c_state,h[3], nar);
       set_first_son (aux, son);
       break;
     case texternal_offer :
       if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
	 set_first_son (aux, son);
	 aux->value1 = (CLR_TYPE)((int)aux->value1 + 8);          /* class */
       }
       son = (TNODE*)fdclr (c_state,h[3], nar);
       set_first_son (aux, son);
			       /* if external_offer, experiments may exist */
       if ((son = (TNODE*)fdclr (c_predicate,h[2], nar)) != NULL) {
	 set_first_son (aux, son);
	 aux->value1 = (CLR_TYPE)((int)aux->value1 + 2);          /* class */
       }
       if ((son = (TNODE*)fdclr (c_experiment_list,h[2], nar)) != NULL) {
	 set_first_son (aux, son);
	 aux->value1 = (CLR_TYPE)((int)aux->value1 + 1);          /* class */
       }
       break;
       default : fatal_error ("unknow node type", __FILE__, __LINE__);
     }
    return (CLR_TYPE) aux;
  }
  case 50:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *initial = NULL,
	   *son = NULL, *first_brothers = NULL;
     if (h[1] != NULL) {
       aux = cp_tree ((TNODE*)h[1], TRUE);
       aux->type = tannotation_list;
       initgl;
       putgrn (_annotation_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);     /* set grnl */
       set_grn_type (aux->sons, tannotation, _annotation_1);
     }
	    /* we have to check if some annotation comes from the son */
	    /* h[1] (example, C annotation). In principle, they are     */
	    /* expected as annotation, rather than annot_list.        */
	    /* fdclr (c_annot,h[2], nar) will be NULL if such        */
	    /* annotation(s) do(es) not exist.                        */
     if ((initial = (TNODE*)fdclr (c_annot,h[2], nar)) != NULL)
			/* They have to be chained as OLDEST brothers */
       if (aux != NULL) {
	 if (!lnsons (aux, initial))
	   fatal_error ("cannot link sons", __FILE__, __LINE__);
       }
       else
	 aux = mk_annot_list (initial);
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       first_brothers = (TNODE*)fdclr (c_annot,h[0], nar);
     if (first_brothers != NULL)
       if (aux != NULL) {             /* annotation_list was created */
	 son = aux->sons;
	 aux->sons = first_brothers;
	 for ( ; first_brothers->brothers != NULL;
	      first_brothers= gt_rb (first_brothers))
	   first_brothers->father = aux;
	 first_brothers->father = aux;
	 first_brothers->brothers = son;
       }
       else
	 aux = mk_annot_list (first_brothers);
      return (CLR_TYPE) aux;
  }
  case 51:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     initgl;
     putgrn (_external_offer_1);               /* grnl for this node */
     putgrn (state_15);                 /* it depends on LBM.spe */
     aux = do_node (texternal_offer, 4);
     set_attr (c_gate_id, aux, fdclr (c_idref,h[1], nar));
      return (CLR_TYPE) aux ;
  }
  case 52:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL, *initial = NULL;
     if (h[2] != NULL) {
       for (aux = gt_fs ((TNODE*)h[2]);
	    aux != NULL;
	    aux = gt_rb (aux)) {
	 son = cp_tree (aux, TRUE);
	 son->type = tannotation;
	 initgl;
	 putgrn (_annotation_1);
	 son->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);  /* set grnl */
	 initial = chain_brothers (initial, son);
       }
     }
      return (CLR_TYPE) initial;
  }
  case 53:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) NULL;
  case 54:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) NULL;
  case 55:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     initgl;
     putgrn (_external_offer_1);               /* grnl for this node */
     putgrn (state_15);                 /* it depends on LBM.spe */
     aux = do_node (texternal_offer, 4);
     set_attr (c_gate_id, aux, fdclr (c_idref,h[1], nar));
      return (CLR_TYPE) aux ;
  }
  case 56:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_experiment_list,h[2], nar);
  case 57:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_predicate,h[3], nar);
  case 58:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL, *initial = NULL;
     if (h[4] != NULL) {
       for (aux = gt_fs ((TNODE*)h[4]);
	    aux != NULL;
	    aux = gt_rb (aux)) {
	 son = cp_tree (aux, TRUE);
	 son->type = tannotation;
	 initgl;
	 putgrn (_annotation_1);
	 son->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);  /* set grnl */
	 initial = chain_brothers (initial, son);
       }
     }
      return (CLR_TYPE) initial;
  }
  case 59:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     initgl;
     putgrn (_internal_action_1);               /* grnl for this node */
     putgrn (state_16);                  /* it depends on LBM.spe */
     aux = do_node (tinternal_action, 1);
      return (CLR_TYPE) aux;
  }
  case 60:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL, *initial = NULL;
     if (h[1] != NULL) {
       for (aux = gt_fs ((TNODE*)h[1]);
	    aux != NULL;
	    aux = gt_rb (aux)) {
	 son = cp_tree (aux, TRUE);
	 son->type = tannotation;
	 initgl;
	 putgrn (_annotation_1);
	 son->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);  /* set grnl */
	 initial = chain_brothers (initial, son);
       }
     }
      return (CLR_TYPE) initial;
  }
  case 61:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) NULL;
  case 62:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
     TNODE *aux = NULL, *son = NULL;
	       /* The colour var_id_node is a set of chained   */
	       /* brothers, one for each variable declaration. */
     initgl;
     putgrn (_experiment_list_1);        /* grnl for this node */
     aux = do_node (texperiment_list, 0);
     for (son = gt_fs ((TNODE*)h[0]);
	  son != NULL;
	  son = gt_rb (son)) {
       if (find_attr (c_value_exp, son) != NULL)
	 if (!lnsons (aux, (TNODE*)fdclr (c_value_exp, son, nar)))
	   fatal_error ("cannot link son", __FILE__, __LINE__);
       if (find_attr (c_var_id_node, son) != NULL)
	 if (!lnsons (aux, (TNODE*)fdclr (c_var_id_node, son, nar)))
	   fatal_error ("cannot link son", __FILE__, __LINE__);
     }
     if (aux->sons != NULL) {
       aux->value1 = (CLR_TYPE) 1;                   /* class */
	return (CLR_TYPE) aux;
     }
      return (CLR_TYPE) NULL;
  }
  case 63:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_var_id_node,h[1], nar);
  case 64:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) TRUE;
  case 65:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     aux = cp_tree ((TNODE*)h[1], TRUE);
     aux->type = tvalue_exp;
     initgl;
     putgrn (_value_exp_1);
     putgrn (experiment_2);               /* it depends on LBM.spe */
     aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);
				/* sets tvalue_exp and grn in all sons */
     set_grn_type (aux->sons, tvalue_exp, _value_exp_1);
      return (CLR_TYPE) aux;
  }
  case 66:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     if (h[1] != NULL) {
       initgl;
       putgrn (_predicate_1);           /* grnl for this node */
       aux = do_node (tpredicate, 3);      /* 3 sons at least */
       son = (TNODE*)fdclr (c_value_exp2,h[1], nar);      /* set 2nd son */
       set_first_son (aux,son);
       son = (TNODE*)fdclr (c_value_exp,h[1], nar);       /* set 1st son */
       set_first_son (aux,son);
     }
      return (CLR_TYPE) aux;
  }
  case 67:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     initgl;
     putgrn (_stop_exp_1);
     putgrn (state_17);                       /* it depends on LBM.spe */
     aux = do_node (tstop_exp, 0);
						   /* set the sons, if any */
     aux->sons = (TNODE*)fdclr (c_annot_list,h[0], nar);
     aux->value1 = (CLR_TYPE)((aux->sons == NULL) ? 0 : 1);       /* class */
      return (CLR_TYPE) aux;
  }
  case 68:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL, *first_brothers = NULL;
     if (h[1] != NULL) {
       aux = cp_tree ((TNODE*)h[1], TRUE);
       aux->type = tannotation_list;
       initgl;
       putgrn (_annotation_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);     /* set grnl */
       set_grn_type (aux->sons, tannotation, _annotation_1);
     }
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       first_brothers = (TNODE*)fdclr (c_annot,h[0], nar);
     if (first_brothers != NULL)
       if (aux != NULL) {             /* annotation_list was created */
	 son = aux->sons;
	 aux->sons = first_brothers;
	 for ( ; first_brothers->brothers != NULL;
	      first_brothers= gt_rb (first_brothers))
	   first_brothers->father = aux;
	 first_brothers->father = aux;
	 first_brothers->brothers = son;
       }
       else
	 aux = mk_annot_list (first_brothers);
      return (CLR_TYPE) aux;
  }
  case 69:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_exit_exp_1);                     /* grnl for this node */
     putgrn (state_18);                 /* it depends on LBM.spe */
     aux = do_node (texit_exp, 0);
					     /* set the sons, if any */
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 2);      /* class */
     }
     if ((son = (TNODE*)fdclr (c_exit_offer_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 1);      /* class */
     }
      return (CLR_TYPE) aux;
  }
  case 70:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     if (h[2] != NULL) {
       aux = cp_tree ((TNODE*)h[2], TRUE);
       aux->type = texit_offer_list;
       initgl;
       putgrn (_exit_offer_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);     /* set grnl */
       for (son = aux->sons; son != NULL; son = gt_rb (son)) {
		   /* Sons can be _value_expression or _sort_identifier */
	 if (son->type == tvalue_expression) {
	   son->type = tvalue_exp;
	   initgl;                /* set tvalue_exp y grn for this node */
	   putgrn (_value_exp_1);
	   putgrn (exit_ent_1);            /* it depends on LBM.spe */
	   son->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl); /* set grnl */
				 /* sets tvalue_exp and grn in all sons */
	   set_grn_type (son->sons, tvalue_exp, _value_exp_1);
	 }
	 else {                       /* it have to be _sort_identifier */
	   son->type = tsort_id;
	   initgl;                /* set tvalue_exp y grn for this node */
	   putgrn (_sort_id_1);
	   putgrn (exit_ent_2);            /* it depends on LBM.spe */
	   son->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl); /* set grnl */
	   set_attr (c_sort, son, find_attr (c_idref, son)->value);
	 }
       }
     }
      return (CLR_TYPE) aux;
  }
  case 71:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL, *first_brothers = NULL;
     if (h[1] != NULL) {
       aux = cp_tree ((TNODE*)h[1], TRUE);
       aux->type = tannotation_list;
       initgl;
       putgrn (_annotation_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);     /* set grnl */
       set_grn_type (aux->sons, tannotation, _annotation_1);
     }
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       first_brothers = (TNODE*)fdclr (c_annot,h[0], nar);
     if (first_brothers != NULL)
       if (aux != NULL) {             /* annotation_list was created */
	 son = aux->sons;
	 aux->sons = first_brothers;
	 for ( ; first_brothers->brothers != NULL;
	      first_brothers= gt_rb (first_brothers))
	   first_brothers->father = aux;
	 first_brothers->father = aux;
	 first_brothers->brothers = son;
       }
       else
	 aux = mk_annot_list (first_brothers);
      return (CLR_TYPE) aux;
  }
  case 72:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_state,h[2], nar);
  case 73:
    h[0]= gt_ft (r);
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL, *initial = NULL;
     /* The annotation from this node will go down the tree up    */
     /* to find a node in which a 'state' node be built. In that  */
     /* place, these annotations will join the local of such node */
     /* They will descend the tree as some chained brothers.      */
     if (h[1] != NULL) {
       for (aux = gt_fs ((TNODE*)h[1]);
	    aux != NULL;
	    aux = gt_rb (aux)) {
	 son = cp_tree (aux, TRUE);
	 son->type = tannotation;
	 initgl;
	 putgrn (_annotation_1);
	 son->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);  /* set grnl */
	 initial = chain_brothers (initial, son);
       }
     }
      return (CLR_TYPE) initial;
  }
  case 74:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_BUT_instantiation_1);           /* grnl for this node */
     putgrn (state_19);                /* it depends on LBM.spe */
     aux = do_node (tBUT_instantiation, 0);
				   /* class may be modified by sons */
     set_attr (c_BUT_number, aux, fdclr (c_idref,h[2], nar));
     if (h[3] != NULL)
       set_attr (c_gate_list, aux, fdclr (c_gate_list,h[3], nar));
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 2);
     }
     if ((son = (TNODE*)fdclr (c_val_exp_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 1);
     }
      return (CLR_TYPE) aux;
  }
  case 75:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL, *son = NULL, *first_brothers = NULL;
     if (h[1] != NULL) {
       aux = cp_tree ((TNODE*)h[1], TRUE);
       aux->type = tannotation_list;
       initgl;
       putgrn (_annotation_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);     /* set grnl */
       set_grn_type (aux->sons, tannotation, _annotation_1);
     }
			     /* Annotations may come from the father */
     if (find_attr (c_annot, h[0]) != NULL)
       first_brothers = (TNODE*)fdclr (c_annot,h[0], nar);
     if (first_brothers != NULL)
       if (aux != NULL) {             /* annotation_list was created */
	 son = aux->sons;
	 aux->sons = first_brothers;
	 for ( ; first_brothers->brothers != NULL;
	      first_brothers= gt_rb (first_brothers))
	   first_brothers->father = aux;
	 first_brothers->father = aux;
	 first_brothers->brothers = son;
       }
       else
	 aux = mk_annot_list (first_brothers);
      return (CLR_TYPE) aux;
  }
  case 76:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     if (h[4] != NULL) {
       aux = cp_tree ((TNODE*)h[4], TRUE);
       aux->type = tvalue_exp_list;
       initgl;
       putgrn (_value_exp_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);    /* set grnl */
				/* sets tvalue_exp and grn in all sons */
       set_grn_type (aux->sons, tvalue_exp, _value_exp_1);
     }
      return (CLR_TYPE) aux;
  }
  case 77:
    h[0]= r;
    heval (h[0], h);
   return (CLR_TYPE) fdclr (c_gate_list,h[1], nar);
  case 78:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_var_domain_list_1);             /* grnl for this node */
     aux = do_node (tvar_domain_list, 1);
     for (son = gt_fs ((TNODE*)h[0]);
	  son != NULL;
	  son = gt_rb (son))
       if (!lnsons (aux, (TNODE*)fdclr (c_var_id_node, son, nar)))
	 fatal_error ("cannot link sons", __FILE__, __LINE__);
      return (CLR_TYPE) aux;
  }
  case 79:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

      return (CLR_TYPE) reduce ((REDUCER) INTappend, h[1],
		    c_gte_var_list, (CLR_TYPE)NULL, nar);
  case 80:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);

	     return (CLR_TYPE) fdclr (c_is_experiment,h[0], nar);
  case 81:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_var_id_node,h[1], nar);
  case 82:
    h[0]= r;
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_gte_var_list,h[1], nar);
  case 83:
    h[0]= gt_ft (r);
    heval (h[0], h);

      return (CLR_TYPE) fdclr (c_is_experiment,h[0], nar);
  case 84:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
     TNODE *aux = NULL, *son = NULL;
     initgl;
     putgrn (_gate_domain_list_1);            /* grnl for this node */
     aux = do_node (tgate_domain_list, 1);
     for (son = gt_fs((TNODE*)h[0]);
	  son != NULL;
	  son = gt_rb (son))
       if (!lnsons (aux, (TNODE*)fdclr (c_gate_domain, son, nar)))
	 fatal_error ("cannot link sons", __FILE__, __LINE__);
      return (CLR_TYPE) aux;
  }
  case 85:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

      return (CLR_TYPE) reduce ((REDUCER) INTcons, h[1],
		    c_idref, (CLR_TYPE)NULL, nar);
  case 86:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

      return (CLR_TYPE) reduce ((REDUCER) INTcons, h[1],
		    c_iddec, (CLR_TYPE)NULL, nar);
  case 87:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     initgl;
     putgrn (_gate_domain_1);               /* grnl for this node */
     aux = do_node (tgate_domain, 0);
     set_attr (c_gate_decl, aux, fdclr (c_gte_var_list,h[1], nar));
     set_attr (c_gate_list, aux, fdclr (c_gate_list,h[2], nar));
      return (CLR_TYPE) aux ;
  }
  case 88:
    h[0]= gt_ft (r);
    heval (h[0], h);
   return (CLR_TYPE) FALSE;
  case 89:
    h[0]= gt_ft (r);
    h[1]= gt_fs (h[0]);
    h[3]= r;
    h[4]= gt_rb (h[3]);
    h[5]= gt_ls (h[0]);

      return (CLR_TYPE) fdclr (c_is_experiment,h[0], nar);
  case 90:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);
  {
     TNODE   *aux = NULL, *son = NULL;
       /* For each declared variable declared in                      */
       /* fdclr (c_gte_var_list,h[1], nar), a _var_id node */
       /* have to be created (in the node _identifier). They are      */
       /*  return (CLR_TYPE)ed in the color var_id as several chained brothers.   */
     for (son = gt_fs ((TNODE*)h[0]);
	  son != NULL;
	  son = gt_rb (son))
       aux = chain_brothers (aux, (TNODE*)fdclr (c_var_id_node, son, nar));
      return (CLR_TYPE) aux;
  }
  case 91:
    h[0]= r;
    h[1]= gt_fs (h[0]);
    h[5]= gt_ls (h[0]);

      return (CLR_TYPE) reduce ((REDUCER) INTcons, h[1],
		    c_iddec, (CLR_TYPE)NULL, nar);
  case 92:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE   *aux = NULL, *son = NULL;
     initgl;
     putgrn (_var_id_1);                        /* grnl for this node */
	     /* This node can be built for an experiment_list or for  */
	     /* a var_domain_list. In the first case, there is a node */
	     /* without '_', so we need to upgrade the grnl.          */
     if ((int)fdclr (c_is_experiment,h[0], nar))
       putgrn (experiment_1);            /* it depends on LBM.spe */
     aux = do_node (tvar_id, 0);
     set_attr (c_var_id, aux, fdclr (c_iddec,h[0], nar));
     if ((son = (TNODE*)fdclr (c_annot_list,h[0], nar)) != NULL) {
       set_first_son (aux, son);
       aux->value1 = (CLR_TYPE)((int)aux->value1 + 1);
     }
      return (CLR_TYPE) aux;
  }
  case 93:
    h[0]= r;
    heval (h[0], h);
  {
     TNODE *aux = NULL;
     if (h[1] != NULL) {
       aux = cp_tree ((TNODE*)h[1], TRUE);
       aux->type = tannotation_list;
       initgl;
       putgrn (_annotation_list_1);
       aux->value0 = (CLR_TYPE)IAT_IT_add (gl, omgrnl);     /* set grnl */
       set_grn_type (aux->sons, tannotation, _annotation_1);
     }
      return (CLR_TYPE) aux;
  }
     }
  return (CLR_TYPE)NULL;
}





PUBLIC void
rag (r)
    TNODE* r;
{
  PROCESINI (r);
  if (ragerrors == 0)
    todo (r);
} /* end of rag */
