/******************************************************
 *      om.c: Lambda Beta CAST builder
 ******************************************************/
/***********************************
     (C) Copyright 1992-1993; dit/upm
     Distributed under the conditions stated in the
     TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: swbus.h,v $
 * Revision 1.6  1993/01/18  18:13:04  lotos
 * distribution issues
 *
 * Revision 1.5  1993/01/12  20:20:43  lotos
 * portability issues
 *
 * Revision 1.4  1993/01/12  14:22:47  lotos
 * use conf.h for portability
 *
 * Revision 1.3  1992/09/11  16:48:24  lotos
 * bug fixing
 *
 * Revision 1.2  1992/09/02  17:12:58  lotos
 * colour c_pr is included in 'colours.c'
 * so, deleted from here.
 *
 * Revision 1.1  1992/09/02  16:07:33  lotos
 * Initial revision
 *
 ************************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <assert.h>
# include "version.h"

# include "cast.hh"
# include "rag.hh"
# include "omnodes.h"
# include "omgrc.h"

typedef CLR_TYPE (*REDUCER)();

# include "colours.h"
#define c_lbm			95
#define c_state			96
#define c_BUT_def_list		97
#define c_BUT_list		98
#define c_BUT_def		99

#define c_gate_id		101
#define c_annot_list		103
#define c_last_annot_list	104
#define c_annot			105
#define c_experiment_list	106
#define c_gate_list		107
#define c_var_list		108
#define c_gte_var_list		109
#define c_val_exp_list		110
#define c_value_exp		111
#define c_value_exp2		112
#define c_BUT_number		113
#define c_exit_offer_list	114
#define c_par_type		115
#define c_gate_decl		116
#define c_ident_equation_list	117
#define c_ident_equation	118
#define c_predicate		119
#define c_var_id		120
#define c_var_id_node		121
#define c_var_domain_list	122
#define c_gate_domain_list	123
#define c_gate_domain		124
#define c_is_experiment		125

#define FULL_SYNCH 1   /* To differentiate the parallels */
#define INTER      2
#define EXPLI      3

#define initgl    gl->size = 0
#define putgrn(n) (void)ITadd (n, gl)

SHARED char	*progname;
SHARED IAT	*omgrnl;   /* auxiliar to generate the grn list */
SHARED IT	*gl;       /* auxiliar to generate grn for each node */

void		set_grn_type ();
TNODE		*do_node ();
TNODE		*chain_brothers ();
CLR_TYPE	reduce ();
void		fatal_error ();
TNODE*		mk_annot_list ();
