/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: elib.c,v $
 * Revision 2.6  1993/01/18  18:11:22  lotos
 * distribution issues
 *
 * Revision 2.5  1993/01/12  14:20:48  lotos
 * place closing parenthesises in such a way
 * that OF SORT qualifiers are properly associated
 * in later rescanning
 * (it does not respect user layout!)
 *
 * Revision 2.4  1992/09/11  16:46:03  lotos
 * adapt to new location of annotations
 *
 * Revision 2.3  1992/02/21  18:39:59  lotos
 * write process name at ENDPROC
 *
 * Revision 2.2  92/02/21  17:16:14  lotos
 * better printing of excomments
 * 
 * Revision 2.1  92/02/07  17:27:34  lotos
 * complete remake of reshuffling functions
 * 
 * Revision 1.4  92/01/14  15:24:30  lotos
 * distribution issues
 * 
 * Revision 1.3  91/04/12  11:36:11  lotos
 * make sprintf compatible for System V
 * 
 * Revision 1.2  91/02/28  19:38:33  lotos
 * better folding of boxes H->V
 * annotations are considered
 * 
 * Revision 1.1  91/01/31  16:07:26  lotos
 * Initial revision
 * 
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: elib.c,v 2.6 1993/01/18 18:11:22 lotos Exp $";
#endif

/* LINTLIBRARY */

# include "swbus.h"
# include "box.hh"

PUBLIC char*
cident (lexv, iddec, idref)
  char* lexv;
  int iddec;
  int idref;
{
  char auxid[BUFSIZ];
  int uid;

  if (flagu) {
    if (iddec != -1)
      uid= iddec;
    else
      uid= idref;
    if (flagl) 
      (void) sprintf (auxid, "%s:%d", lexv, uid);
    else
      (void) sprintf (auxid, "%d", uid);
    return str_alloc (auxid);
  }
  else
    return lexv;
}

PUBLIC BOX
bident (nd)
  TNODE* nd;
{
  TATTR* attr;
  char* lexid= NULL;
  int iddec= -1;
  int idref= -1;

  if (attr= find_attr (c_iddec, nd)) {
    iddec= (int) attr->value;
    lexid= l2s (iddec);
  }
  else if (attr= find_attr (c_idref, nd)) {
    idref= (int) attr->value;
    lexid= l2s (idref);
  }
  else if (attr= find_attr (c_lexv, nd))
    lexid= SymbolTable->data[(int)attr->value];
  else {
    fprintf (stderr, "impossible to get an identifier!\n");
    exit (1);
  }
  return batom (cident (lexid, iddec, idref));
}

PUBLIC void
dendproc (indent, nd)
  int indent;
  TNODE* nd;
{
  static char tmpbuf[512];
  TATTR* attr;
  char* lexid= NULL;
  int iddec= -1;
  int idref= -1;

  if (attr= find_attr (c_iddec, nd)) {
    iddec= (int) attr->value;
    lexid= l2s (iddec);
  }
  else if (attr= find_attr (c_idref, nd)) {
    idref= (int) attr->value;
    lexid= l2s (idref);
  }
  else if (attr= find_attr (c_lexv, nd))
    lexid= SymbolTable->data[(int)attr->value];
  else {
    fprintf (stderr, "impossible to get an identifier!\n");
    exit (1);
  }
  (void) sprintf (tmpbuf, "ENDPROC (* %s *)",
		  cident (lexid, iddec, idref));
  displaystr (indent, tmpbuf);
}

PUBLIC BOX
slist (nd, sch)
  TNODE* nd;
  char* sch;
{
  pbegin ();
  for (nd= nd->sons; nd != NULL; nd= nd->brothers) {
    if (nd->brothers) {
      pbegin ();
	pbox ((BOX) fdclr (c_box, nd, -31));
	patom (sch);
      pbox (pend (HD));
    }
    else
      pbox ((BOX) fdclr (c_box, nd, -32));
  }
  return pend (OPTS);
}

PRIVATE void
bveil (nd)	/* Build Value Expression Infix Left */
  TNODE* nd;
{
  if (find_attr (c_infix, nd->sons) &&
      ! find_attr (c_paren, nd->sons)) {
    bveil (nd->sons);
    pbegin ();
      pbox (build_ve (nd->sons->sons->brothers));
      pbox (bident (nd));
    pbox (pend (HS));
  }
  else {
    pbegin ();
      pbegin ();
	pbox (build_ve (nd->sons));
	pbox (bident (nd));
      pbox (pend (HS));
  }
}

PUBLIC BOX
build_ve (nd)
  TNODE* nd;
{
  int paren= -1;
  int pp;
  TNODE* and;

  pbegin ();
  if (find_attr (c_paren, nd))
    paren= (int) fdclr (c_paren, nd, -7);
  for (pp= paren; pp >= 0; pp--)
    patom ("(");
  if (find_attr (c_infix, nd)) {
    if (find_attr (c_infix, nd->sons) &&
	! find_attr (c_paren, nd->sons)) {
      bveil (nd->sons);
      pbegin ();
	pbox (build_ve (nd->sons->sons->brothers));
	pbox (bident (nd));
      pbox (pend (HS));
      pbox (build_ve (nd->sons->brothers));
      pbox (pend (OPTS));
    }
    else {
      pbegin ();
	pbox (build_ve (nd->sons));
	pbox (bident (nd));
	pbox (build_ve (nd->sons->brothers));
      pbox (pend (OPTS));
    }
  }
  else {
    pbox (bident (nd));
    if (nd->sons) {
      pbegin ();
	patom (" (");
	pbegin ();
	for (and= nd->sons; and != NULL; and= and->brothers) {
	  if (and->brothers) {
	    pbegin ();
	    pbox (build_ve (and));
	    patom (",");
	    pbox (pend (HD));
	  }
	  else
	    pbox (build_ve (and));
	}
	pbox (pend (OPTS));
	patom (")");
      pbox (pend (HD));
    }
  }
  for (pp= paren; pp >= 0; pp--)
    patom (")");
  if (find_attr (c_ofsort, nd)) {
    patom (" OF ");
    patom (cident (SymbolTable->data[(int)find_attr(c_ofsort, nd)->value],
		   -1,
		   find_attr (c_sidref, nd) ?
		     (int) find_attr (c_sidref, nd)->value :
		     -1 ));

  }
  return pend (HD);
}

PUBLIC BOX
pr_excom (nd, clr)
  TNODE* nd;
  int clr;
{
  char* exsp;
  char* exsf;
  TATTR* att;

  att= find_attr (clr, nd);
  if (att == NULL)
    return NULL;

  pbegin ();
  pbegin ();
  patom ("(*|");
  patom (type2clr(clr)->keyword);
  pbegin ();
  if (att->value) {
    if (strchr ((char*)att->value, '\n') != NULL) {
      exsp= str_alloc ((char*)att->value);
      exsf= strchr (exsp, '\n');
      while (exsf != NULL) {
	*exsf= '\0';
	while (*exsp == ' ' || *exsp == '\t')
	  exsp++;
	if (*exsp)
	  patom (exsp);
	exsp= exsf+1;
	if (exsp)
	  exsf= strchr (exsp, '\n');
	else
	  exsf= NULL;
      }
      while (*exsp == ' ' || *exsp == '\t')
	exsp++;
      patom (exsp);
    }
    else {
      patom ((char*)att->value);
    }
  }
  pbox (pend (VL));
  pbox (pend (HS));
  patom ("|*)");
  return pend (OPTS);
}

PRIVATE int possible_colours[]= {
  c_lbc, c_ldc, c_implby, c_initSby, c_initZby,
  c_delay, c_priority, c_wait,
  c_c,
  c_default, c_eval,
  0
  };

PUBLIC BOX
pr_excom_it (nd)
  TNODE* nd;
{
  int i;
  
  for (i= 0; possible_colours[i] != 0; i++)
    if (find_attr (possible_colours[i], nd))
      return pr_excom (nd, possible_colours[i]);
  return NULL;
}

