%{
/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: rdtts.spe,v $
Revision 1.13 2000/07/00  16:32:00  kjt
changed YYMAXDEPTH to 512

Revision 1.12  1993/08/02  16:59:33  lotos
fix declaration of flagxxxx (warning)

Revision 1.11  1993/06/23  16:30:02  lotos
who knows ...?

Revision 1.10  1993/06/23  16:27:36  lotos
no change

Revision 1.8  1993/06/15  13:11:00  lotos
fix colour keys to avoid collisions

Revision 1.6  1993/01/21  20:25:19  lotos
code generation for ildi

Revision 1.5  1993/01/20  13:38:05  lotos
generate test system for lola

Revision 1.3  1993/01/18  17:52:26  lotos
use priority annotations
distribution issues
portability issues

Revision 1.1  1992/11/19  18:22:32  lotos
Initial revision

 ***********************************/

# include "version.h"
#ifndef lint
static char rcsid[]= "$Id: rdtts.spe,v 1.12 1993/08/02 16:59:33 lotos Exp $";
#endif
%}
%{
# include "swbus.h"
# define YYMAXDEPTH      512
# define YYSTYPE         yystype
# define putgrn(n)       (void)ITadd(n, gl)
# define class(nt)       { cls= 0; xxc= nt-1;   \
               for (xc= 0; xc < nt; xc++, xxc--)    \
                             if (stpick(xc)->type != tNULL) \
                 cls += (1 << xxc);}
# define ndput(tp)   { stput(tp);   \
               if (gn != NULL){gn->value0=  \
                  (CLR_TYPE)IAT_IT_add(gl, grnl); \
                  gl->size= 0;} \
               gn= (sttype() == tNULL) ? NULL : sttop(); }
# define ndterm(tp, val) { stput (tp);  \
                       staclr (c_lexv, (CLR_TYPE)val.name); \
                       staclr (c_line, (CLR_TYPE)val.line);}

IT* gl;
TNODE*  gn;
int cls;
int xc;
int xxc;

%}

%token LET 260
%token FOR 261
%token IN 262
%token IMPLICATION 263
%token OF 264
%token IDENTIFIER 265
%token SPECIAL 266

%start specification


%%

I1repp                  :
	 object
	;

I1repp                  :
	 I1repp object
	{ if (errorcount == 0) stlrlink (); }
	;

specification           :
	 I1repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tspecification);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(1);
	}
	}
	;

object                  :
	 definition
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tobject);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(2);
	}
	}
	;

object                  :
	 test_case_block
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tobject);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(3);
	}
	}
	;

definition              :
	 LET identifier_declaration '=' set_declaration_list ';'
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tdefinition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(4);
	}
	}
	;

test_case_block         :
	 test_case
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(ttest_case_block);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(5);
	}
	}
	;

test_case_block         :
	 local_definition_list '[' '[' test_case_list ']' ']'
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(ttest_case_block);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(6);
	}
	}
	;

I2repp_sep              :
	 local_definition
	;

I2repp_sep              :
	 I2repp_sep ',' local_definition
	{ if (errorcount == 0) stlrlink (); }
	;

local_definition_list   :
	 I2repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tlocal_definition_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(7);
	}
	}
	;

local_definition        :
	 FOR identifier_declaration IN set_declaration_list
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tlocal_definition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(8);
	}
	}
	;

local_definition        :
	 FOR matrix IN set_declaration_list
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tlocal_definition);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(9);
	}
	}
	;

matrix                  :
	 identifier_decl operation_identifier identifier_decl ':' sort_identifier
	{
	if (errorcount == 0)
	{
	 class(4);
	 stlrlink ();
	 stlrlink ();
	 stlrlink ();
	 ndput(tmatrix);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(10);
	}
	}
	;

I3repp                  :
	 test_case
	;

I3repp                  :
	 I3repp test_case
	{ if (errorcount == 0) stlrlink (); }
	;

test_case_list          :
	 I3repp
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(ttest_case_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(11);
	}
	}
	;

test_case               :
	 assertion ';'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(ttest_case);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(12);
	}
	}
	;

test_case               :
	 premisses IMPLICATION assertion ';'
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(ttest_case);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(13);
	}
	}
	;

assertion               :
	 simple_equation
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tassertion);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(14);
	}
	}
	;

assertion               :
	 value_expression
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tassertion);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(15);
	}
	}
	;

assertion               :
	 value_expression '!' '=' value_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tassertion);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(16);
	}
	}
	;

I4repp_sep              :
	 set_declaration
	;

I4repp_sep              :
	 I4repp_sep '|' set_declaration
	{ if (errorcount == 0) stlrlink (); }
	;

set_declaration_list    :
	 I4repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tset_declaration_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(17);
	}
	}
	;

set_declaration         :
	 '[' value_expression_list ']'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tset_declaration);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(18);
	}
	}
	;

set_declaration         :
	 identifier
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tset_declaration);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(19);
	}
	}
	;

I5repp_sep              :
	 premiss
	;

I5repp_sep              :
	 I5repp_sep ',' premiss
	{ if (errorcount == 0) stlrlink (); }
	;

premisses               :
	 I5repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tpremisses);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(20);
	}
	}
	;

premiss                 :
	 simple_equation
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tpremiss);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(21);
	}
	}
	;

premiss                 :
	 value_expression
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tpremiss);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(22);
	}
	}
	;

simple_equation         :
	 value_expression '=' value_expression
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tsimple_equation);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(23);
	}
	}
	;

I6opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I6opt                   :
	 OF sort_identifier
	;

value_expression        :
	 term_expression I6opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tvalue_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(24);
	}
	}
	;

I7opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I7opt                   :
	 OF sort_identifier
	;

value_expression        :
	 value_expression operation_identifier term_expression I7opt
	{
	if (errorcount == 0)
	{
	 class(4);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tvalue_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(25);
	}
	}
	;

I8opt                   :
	 /* empty */
	{ ndput (tNULL); }
	;

I8opt                   :
	 '(' value_expression_list ')'
	;

term_expression         :
	 operation_identifier I8opt
	{
	if (errorcount == 0)
	{
	 class(2);
	 if (sttype() == tNULL) stpop();
	 else if (stpick(1)->type == tNULL) {stswap(); stpop();}
	 else stlrlink();
	 ndput(tterm_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(26);
	}
	}
	;

term_expression         :
	 '(' value_expression ')'
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tterm_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(27);
	}
	}
	;

term_expression         :
	 '(' error ')'
	{
	if (errorcount == 0)
	{
	 if (sttype() == tNULL){
		class(0);
		stpop();
	 }
	 else class(1);
	 ndput(tterm_expression);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (cls == 1) stsflink ();
	 putgrn(28);
	}
	}
	;

I9repp_sep              :
	 value_expression
	;

I9repp_sep              :
	 I9repp_sep ',' value_expression
	{ if (errorcount == 0) stlrlink (); }
	;

value_expression_list   :
	 I9repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tvalue_expression_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(29);
	}
	}
	;

identifier_declaration  :
	 identifier_declaration_list ':' sort_identifier
	{
	if (errorcount == 0)
	{
	 class(2);
	 stlrlink ();
	 ndput(tidentifier_declaration);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(30);
	}
	}
	;

I10repp_sep             :
	 identifier_decl
	;

I10repp_sep             :
	 I10repp_sep ',' identifier_decl
	{ if (errorcount == 0) stlrlink (); }
	;

identifier_declaration_list :
	 I10repp_sep
	{
	if (errorcount == 0)
	{
	 class(1);
	 ndput(tidentifier_declaration_list);
	 sttop()->value1= (CLR_TYPE)cls;
	 if (stpick(1)->type == tNULL)
	      {stswap(); stpop();}
	 else stsflink ();
	 putgrn(31);
	}
	}
	;

sort_identifier         :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tsort_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(32);
	}
	}
	;

operation_identifier    :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(toperation_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(33);
	}
	}
	;

operation_identifier    :
	 SPECIAL
	{
	if (errorcount == 0)
	{
	 ndput(toperation_identifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(34);
	}
	}
	;

identifier              :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tidentifier);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(35);
	}
	}
	;

identifier_decl         :
	 IDENTIFIER
	{
	if (errorcount == 0)
	{
	 ndput(tidentifier_decl);
	 staclr (c_lexv, (CLR_TYPE)$1.name);
	 staclr (c_line, (CLR_TYPE)$1.line);
	 putgrn(36);
	}
	}
	;

%%

PRIVATE int
yylex ()
{
    token *tk;

   tk = gtk ();
   yylval = tk->yylval;
   return tk->type;
}

PUBLIC TNODE*
bast ()
{
   gl= ITcreate (4, 2, 1);
   gn= NULL;
   (void)yyparse();
   if (gn != NULL) gn->value0= (CLR_TYPE)IAT_IT_add(gl, grnl);
   return sttop();
}
