/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: rdtts.c,v $
 * Revision 1.7  1993/06/23  16:26:38  lotos
 * better help, with samples
 *
 * Revision 1.6  1993/01/21  20:25:19  lotos
 * code generation for ildi
 *
 * Revision 1.5  1993/01/20  13:38:05  lotos
 * generate test system for lola
 *
 * Revision 1.4  1993/01/18  17:52:46  lotos
 * distribution issues
 *
 * Revision 1.3  1993/01/12  20:21:47  lotos
 * portability issues
 *
 * Revision 1.2  1993/01/12  14:40:09  lotos
 * fix details to port to pc
 *
 * Revision 1.1  1992/11/19  18:22:43  lotos
 * Initial revision
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: rdtts.c,v 1.7 1993/06/23 16:26:38 lotos Exp $";
#endif

# include "swbus.h"
# include "emit.h"
# include "lexana.h"

PRIVATE void    makenames ();
PRIVATE void    help ();
PRIVATE FILE*   efopen();

PRIVATE TIOCOLOURS iocolours [] = {
# include "colours.c"
	"tree",     c_tree,     NULL, save_tree, NULL, NULL,
	"troo",     c_troo,     NULL, save_tree, NULL, NULL,
        "ckey",     c_ckey,     IO_str,
        "cval",     c_cval,     IO_str,
	"vclrs",    c_vclrs,    IO_IL,
	"decl",     c_decl,     NULL, save_tree, NULL, NULL,
	"set",      c_set,      NULL, save_tree, NULL, NULL,
	"store",    c_store,    IO_int,
	"scope",    c_scope,    NULL, NULL, NULL, NULL,
	"scopein",  c_scopein,  NULL, NULL, NULL, NULL,
	"scopeout", c_scopeout, NULL, NULL, NULL, NULL,
	"ldefs",    c_ldefs,    IO_SL,

	"keylist",  c_keylist,  IO_IL,
	"vallist",  c_vallist,  IO_SL,
	OTHERS
        };

PRIVATE void
makenames ()
{
  char *p1;

  nfname= -1;
  if (strlen (ArgvFileName) == 0) {
    help ();
    exit (1);
  }
  else {
    (void) strcpy (RootFileName, ArgvFileName);
    p1 = strrchr (RootFileName, '/');
    if (p1)
      (void) strcpy (RootFileName, ++p1);
    p1= strrchr (RootFileName, '.');
    if (p1) {
      if (strcmp (p1, ".tts") == 0 || strcmp (p1, ".lot") == 0)
	*p1 = '\0';
    }
  }
  (void) strcpy (TtsFileName, RootFileName);
  (void) strcat (TtsFileName, ".tts");
  nfname= STHadd (TtsFileName, SymbolTable, hidtbl, FALSE);
  (void) strcpy (LotFileName, RootFileName);
  (void) strcat (LotFileName, ".lot");
}

PRIVATE	FILE*
efopen(file, mode) 
     char* file;
     char* mode; 
{
  FILE* fp;
  FILE* fopen();

  if ((fp= fopen (file, mode)) == NULL) {
    (void) fprintf (stderr,
		    "cannot open file %s mode %s\n",
		    file, mode);
    exit (1);
  }
  return fp;
} /* end of efopen */

#define PF(msg) (void) fprintf (stderr, "%s\n", msg)
PRIVATE void
help    ()
{
  PF ("usage: rdtts [opcs] source[.tts]");
  PF ("TOPO: C compiler:");
  PF ("  topo S -rdtts [-topo] > T.lot");
  PF ("  topo T -p");
  PF ("  T");
  PF ("");
  PF ("LOLA: LOTOS Laboratory:");
  PF ("  topo S -rdtts  -lola  > T.lot");
  PF ("  topo T -lola");
  PF ("  lola> test -1 OK RunTest");
  PF ("");
  PF ("ILDI: Data Interpreter:");
  PF ("  topo S -rdtts  -ildi  > T.scr");
  PF ("  topo S -ildi < T.scr");
}

PUBLIC int
main (argc, argv)
     int argc;
     char* argv[];
{
  TNODE* tree;
  TNODE *this, *next, *new,
  *thefather, *leftbrother, *rightbrother;
  
  while (argc > 1) {
    if (strcasecmp (argv[1], "-topo") == 0) {
      flagtopo++;
      argc--; argv++;
      continue;
    }
    if (strcasecmp (argv[1], "-lola") == 0) {
      flaglola++;
      argc--; argv++;
      continue;
    }
    if (strcasecmp (argv[1], "-ildi") == 0) {
      flagildi++;
      argc--; argv++;
      continue;
    }
    if (strcasecmp (argv[1], "-d") == 0) {
      flagd++;
      argc--; argv++;
      continue;
    }

    if (strncasecmp (argv[1], "-", 1) == 0) {
      help ();
      exit (1);
    }

    ArgvFileName= argv[1];
    argc--; argv++;
  }

  if (flaglola && flagildi) {
    help ();
    exit (1);
  }

  if (! (flaglola || flagildi))
    flagtopo++;

  cast_init(iocolours);
  stinit(5000);
  SymbolTable= STcreate(100, 0, 1, 0);
  hidtbl= STHinit (SymbolTable, 5119);
  grnl= IATcreate (100, 10, 1);
  
  makenames ();
  sfp = efopen (TtsFileName, "r");
  ofp = efopen (LotFileName, "r");
  
  tree= bast();
  
  if (errorcount > 0 || tree == NULL) {
    if (errorcount == 1)
      (void) fprintf (stderr, "1 error found\n");
    else
      (void) fprintf (stderr, "%d errors found\n", errorcount);
    exit (1);
  }
  
  if (errorcount == 0 && tree != NULL) {
    set_attr(c_ll, tree, (CLR_TYPE) SymbolTable);
    set_attr(c_grnl, tree, (CLR_TYPE) grnl);
    rag(tree);
    if (ragerrors != 0) {
      (void) fprintf (stderr, "***  rdtts: errors detected\n");
      if (flagd > 0)
	save_tree (stdout, tree);
      exit (1);
    }
    
    for (this= tree; this != NULL; this= next) {
      if (find_attr (c_tree, this)) {
	new= (TNODE*)find_attr (c_tree, this)->value;
	thefather= gt_ft (this);
	leftbrother= gt_lb (this);
	rightbrother= gt_rb (this);
	
	this->sons= NULL;
	next= succ (this, PREORDER);
	
	if (new) {
	  if (leftbrother)
	    leftbrother->brothers= new;
	  else
	    thefather->sons= new;
	  new->father= thefather;
	  new->brothers= rightbrother;
	}
	else {
	  if (leftbrother)
	    leftbrother->brothers= rightbrother;
	  else
	    thefather->sons= rightbrother;
	}
      }
      else
	next= succ (this, PREORDER);
    }
    
    if (ragerrors != 0) {
      (void) fprintf (stderr, "***  rdtts: errors detected\n");
      if (flagd > 0)
	save_tree (stdout, tree);
      exit (1);
    }
  }
  if (flagd < 1) {
    name2clr("tree")	->put= NULL;
    name2clr("troo")	->put= NULL;
    name2clr("ckey")	->put= NULL;
    name2clr("cval")	->put= NULL;
    name2clr("vclrs")	->put= NULL;
    name2clr("keylist")	->put= NULL;
    name2clr("vallist")	->put= NULL;
  }
  else
    save_tree(stdout, tree);
  EmitSpecification (tree);
  exit (0);
  return 0;
}
