/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: scopes.c,v $
 * Revision 1.1  1993/01/21  20:25:19  lotos
 * Initial revision
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: scopes.c,v 1.1 1993/01/21 20:25:19 lotos Exp $";
#endif

# include "scopes.h"

PUBLIC scope*
lookup (scp, key)
  scope* scp;
  char* key;
{
  scope* s;

  for (s= scp; s != NULL; s= s->next)
    if (strcmp (s->key, key) == 0)
      return s;
  return NULL;
}

PUBLIC scope*
install (scp, key, decl, set)
  scope* scp;
  char* key;
  char* decl;
  TNODE* set;
{
  scope* e;

  if (lookup (scp, key) != NULL) {
    (void) fprintf (stderr, "duplicated name: %s\n", key);
    ragerrors++;
    return scp;
  }

  e= (scope*) malloc (sizeof (scope));
  e->key= key;
  e->decl= decl;
  e->set= set;
  e->next= scp;
  return e;
}

PUBLIC TNODE*
find (scp, key)
  scope* scp;
  char* key;
{
  scope* s;

  if (s= lookup (scp, key))
      return s->set;
  return NULL;
}

