/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: swbus.h,v $
 * Revision 1.7  1993/06/15  13:11:00  lotos
 * fix colour keys to avoid collisions
 *
 * Revision 1.6  1993/01/21  20:29:56  lotos
 * clean data organization in modules
 *
 * Revision 1.5  1993/01/20  13:38:05  lotos
 * generate test system for lola
 *
 * Revision 1.4  1993/01/18  17:53:03  lotos
 * distribution issues
 *
 * Revision 1.3  1993/01/12  20:21:56  lotos
 * portability issues
 *
 * Revision 1.2  1993/01/12  14:40:47  lotos
 * use conf.h for portability
 *
 * Revision 1.1  1992/11/19  18:23:07  lotos
 * Initial revision
 *
 ***********************************/

#ifndef SWBUS
#  define SWBUS

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <assert.h>
# include <ctype.h>
# include <string.h>

# define nil(type) (type) NULL
# define l2s(idx) (char*)(SymbolTable->data[(int)idx])
/*
  (char*)(SymbolTable->data[(int)(ATable->data[(int)idx].value1)])
*/

# include "rag.hh"
# include "nodes.h"

/*****  constants  *****/
# include "colours.h"

# define c_tree         101
# define c_troo         102
# define c_ckey         103
# define c_cval         104
# define c_vclrs        105
# define c_decl         106
# define c_set          107
# define c_store        108
# define c_scope        109
# define c_scopein      110
# define c_scopeout     111
# define c_ldefs        112

# define c_keylist	121
# define c_vallist	122


# define BCOMM  -1
# define COMM   -2
# define ECOMM  -3

/*****  exported types  *****/

typedef struct stname {
        int	name;
        int*    line;
	char*	ckey;
	char*	cval;
        } yystype;

typedef struct  {
        int     type;
        yystype yylval;
        } token;

PUBLIC token* gtk ();	/* really in lexana.c; but lag ... */

/*****  exported variables  *****/

SHARED	char*   ArgvFileName;
SHARED	char    RootFileName[BUFSIZ];
SHARED	char    TtsFileName[BUFSIZ];
SHARED	char    LotFileName[BUFSIZ];
SHARED	int     nfname;

SHARED	FILE*   sfp;
SHARED	FILE*   ofp;

SHARED  IAT*    grnl;

SHARED	int     flagd;

SHARED  int     errorcount;
SHARED  int     fcomm;
SHARED  char*   comm;

SHARED	int	LastTestCase;

/*****  exported functions  *****/

PUBLIC	TNODE*	bast	();

/* in order to reuse lexana.c from lfe ... */

# define ACCEPT			567
# define ACTUALIZEDBY		567
# define ANY			567
# define BEHAVIOUR		567
# define CHOICE			567
# define ENDLIB			567
# define ENDPROC		567
# define ENDSPEC		567
# define ENDTYPE		567
# define EQNS			567
# define EXIT			567
# define FORALL			567
# define FORMALEQNS		567
# define FORMALOPNS		567
# define FORMALSORTS		567
# define HIDE			567
# define I			567
# define IS			567
# define LIBRARY		567
# define NOEXIT			567
# define OFSORT			567
# define OPNNAMES		567
# define OPNS			567
# define PAR			567
# define PROCESS		567
# define RENAMEDBY		567
# define SORTNAMES		567
# define SORTS			567
# define SPECIFICATION		567
# define STOP			567
# define STYPE			567
# define USING			567
# define WHERE			567

# define ARROW			567
# define ENABLE			567
# define ENABLE			567
# define LEFT_PAR		567
# define INTERLEAVING		567
# define SYNCHRONIZATION	567
# define FAT_BAR		567
# define DISABLE		567
# define DEFINITION		567
# define RIGHT_PAR		567
# define EXCOMM			567

#endif
