// WindForce.java	K. J. Turner <kjt@cs.stir.ac.uk>	09/10/02

// Java applet to calculate name of wind speed according to settings in miles
// per hour, kilometres per hour, knots and wind force
//
// Provided under the GNU General Public Licence
// (http://www.gnu.org/copyleft/gpl.html)

import java.awt.*;
import java.awt.event.*;
import java.applet.Applet;

public class WindForce extends Applet implements ActionListener {
  private GridBagLayout layout;
  private GridBagConstraints constraints;
  private Label forceLabel, knotLabel, mphLabel, kphLabel, nameLabel;
  private TextField forceText, knotText, mphText, kphText, nameText;
  private String str;
  private int mph, mph1, mph2, kph, knot, force;

  private final double mph_knot = 0.8689762;	// miles/hour to knots
  private final double mph_kph = 1.609344;	// miles/hour to kms/hour
  private final int force_mph [] = {		// force to miles/hour
    0, 1, 4, 8, 13, 19, 25, 32, 39, 47, 55, 64, 73, 137
  };
  private final String force_name [] = {		// wind speed names
    "Calm", "Light Air", "Light Breeze", "Gentle Breeze",
    "Moderate Breeze", "Fresh Breeze", "Strong Breeze", "Near Gale",
    "Gale", "Strong Gale", "Storm", "Violent Storm",
    "Hurricane", "Unknown"
  };

  // set up miles/hour, kms/hour, knots, force, name fields

  public void init () {
    layout = new GridBagLayout ();
    setLayout (layout);
    constraints = new GridBagConstraints ();
    constraints.gridwidth = 1;
    forceLabel = new Label("Force:");	addItem (forceLabel, 0, 0);
    forceText = new TextField (7);	addItem (forceText, 1, 0);
    forceText.addActionListener (this);
    knotLabel = new Label("Knots:");	addItem (knotLabel, 2, 0);
    knotText = new TextField (7);	addItem (knotText, 3, 0);
    knotText.addActionListener (this);
    mphLabel = new Label("Mls/Hr:");	addItem (mphLabel, 0, 1);
    mphText = new TextField (7);	addItem (mphText, 1, 1);
    mphText.addActionListener (this);
    kphLabel = new Label("Kms/Hr:");	addItem (kphLabel, 2, 1);
    kphText = new TextField (7);	addItem (kphText, 3, 1);
    kphText.addActionListener (this);
    nameLabel = new Label("Wind:");	addItem (nameLabel, 0, 2);
    nameText = new TextField (26);	nameText.setEditable (false);
    constraints.gridwidth = 3;		addItem (nameText, 1, 2);
  }

  // handle user entry

  public void actionPerformed (ActionEvent event)
   throws NumberFormatException {
    if (event.getSource () != nameText) {	// not wind name entry?
      str = forceText.getText ();		// save force number
      forceText.setText ("?");			// re-initialise force
      nameText.setText (force_name [force_mph.length - 1]);
      if (event.getSource () == mphText) {	// conversion from miles/hr
	try {
	  mph = Integer.parseInt (mphText.getText ());
	  knot = (int) (mph * mph_knot + 0.5);	// set knots
	  knotText.setText (Integer.toString (knot));
	  kph = (int) (mph * mph_kph + 0.5);	// set kms/hour
	  kphText.setText (Integer.toString (kph));
	  if (setForce (mph))			// set wind force and name
	    showStatus ("Miles/Hour Converted");
	  else
	    showStatus ("Miles/Hour Out of Range");
	}
	catch (NumberFormatException exception) {
	  showStatus ("Miles/Hour not Whole Number");
	}
      }
      else if (event.getSource () == kphText) {	// conversion from kms/hour
	try {
	  kph = Integer.parseInt (kphText.getText ());
	  knot = (int) (mph * mph_knot + 0.5);	// set knots
	  knotText.setText (Integer.toString (knot));
	  mph = (int) (kph / mph_kph + 0.5);	// set miles/hour
	  mphText.setText (Integer.toString (mph));
	  setForce (mph);			// set wind force and name
	  if (setForce (mph))			// set wind force and name
	    showStatus ("Kilometres/Hour Converted");
	  else
	    showStatus ("Kilometres/Hour Out of Range");
	}
	catch (NumberFormatException exception) {
	  showStatus ("Kilometres/Hour not Whole Number");
	}
      }
      else if (event.getSource () == knotText) { // convert from knots
	try {
	  knot = Integer.parseInt (knotText.getText ());
	  mph = (int) (knot / mph_knot + 0.5);	// set miles/hour
	  mphText.setText (Integer.toString (mph));
	  kph = (int) (mph * mph_kph + 0.5);	// set kms/hour
	  kphText.setText (Integer.toString (kph));
	  if (setForce (mph))			// set wind force and name
	    showStatus ("Knots Converted");
	  else
	    showStatus ("Knots Out of Range");
	}
	catch (NumberFormatException exception) {
	  showStatus ("Knots not Whole Number");
	}
      }
      else if (event.getSource () == forceText) { // convert from force number
	try {
        forceText.setText (str);
	  force = Integer.parseInt (forceText.getText ());
	  if ((0 <= force) && (force < force_mph.length - 1)) {
	    mph1 = force_mph [force]; mph2 = force_mph [force + 1] - 1;
	    mphText.setText			// set miles/hour range
	      (Integer.toString (mph1) + "-" +
		Integer.toString (mph2));
	    kphText.setText			// set kms/hour range
	      (Integer.toString ((int) (mph1 * mph_kph + 0.5)) + "-" +
		Integer.toString ((int) (mph2 * mph_kph + 0.5)));
	    knotText.setText			// set knots range
	      (Integer.toString ((int) (mph1 * mph_knot + 0.5)) + "-" +
		Integer.toString ((int) (mph2 * mph_knot + 0.5)));
		nameText.setText (force_name [force]); // set wind name
	    showStatus ("Force Converted");
	  }
	  else
	    showStatus ("Force Out of Range");
	}
	catch (NumberFormatException exception) {
	  showStatus ("Force not Whole Number");
	}
      }
    }
    repaint();
  }

  // add item to grid bag layout

  private void addItem (Component comp, int col, int row) {
    constraints.gridx = col; constraints.gridy = row;
    constraints.gridheight = 1;
    constraints.weightx = 1; constraints.weighty = 1;
    constraints.anchor = GridBagConstraints.WEST;
    layout.setConstraints (comp, constraints);
    add (comp);
  }

  // set wind force and name from miles/hour

  private boolean setForce (int mph)
  {
    if ((0 <= mph) && (mph < force_mph [force_mph.length - 1])) {
      force = -1;				// set force
      while (mph >= force_mph [++force])
	    ;
      force--;
      forceText.setText (Integer.toString (force));
      nameText.setText (force_name [force]);
      return true;
    }
    else
      return false;
  }
}
